/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lykrast.prodigytech.client.gui.GuiAtomicReshaper;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.recipe.AtomicReshaperManager;
import lykrast.prodigytech.common.util.Config;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class AtomicReshaperWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    protected static final String AMOUNT = "container.prodigytech.atomic_reshaper.primordium.amount";
    protected static final String CHANCE = "container.prodigytech.jei.ptreshaper.chance";
    protected static final String CHANCE_LOW = "container.prodigytech.jei.ptreshaper.chance.low";
    private List<ItemStack> in = new ArrayList<ItemStack>();
    private List<List<ItemStack>> out;
    private final IDrawableAnimated arrow;
    private final IDrawable primordiumGauge;
    private int primordiumAmount;
    private int primordiumScale;
    private int totalWeight;
    private int[] weights;

    public AtomicReshaperWrapper(AtomicReshaperManager.AtomicReshaperRecipe recipe, IGuiHelper guiHelper) {
        if (recipe.isOreRecipe()) {
            NonNullList items = OreDictionary.getOres((String)recipe.getOreInput(), (boolean)false);
            this.in.addAll((Collection<ItemStack>)items);
        } else {
            this.in.add(recipe.getInput());
        }
        List<ItemStack> outputs = !recipe.isSingleOutput() ? recipe.getOutputList() : Collections.singletonList(recipe.getSingleOutput());
        this.out = Collections.singletonList(outputs);
        this.weights = recipe.getWeights();
        this.totalWeight = recipe.getTotalWeight();
        this.primordiumAmount = recipe.getPrimordiumAmount();
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(GuiAtomicReshaper.GUI, 176, 0, 48, 17), recipe.getTimeTicks(), IDrawableAnimated.StartDirection.LEFT, false);
        this.primordiumScale = this.primordiumAmount * 52 / (Config.atomicReshaperMaxPrimordium * 100);
        this.primordiumGauge = guiHelper.createDrawable(GuiAtomicReshaper.GUI, 176, 35 + (52 - this.primordiumScale), 4, this.primordiumScale);
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        int primordiumCount = this.primordiumAmount % 100 == 0 ? this.primordiumAmount / 100 : this.primordiumAmount / 100 + 1;
        inputs.add(Collections.singletonList(new ItemStack(ModItems.primordium, primordiumCount)));
        inputs.add(this.in);
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.out);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, 60, 19);
        this.primordiumGauge.draw(minecraft, 30, 1 + (52 - this.primordiumScale));
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX >= 30 && mouseX <= 34) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)AMOUNT, (Object[])new Object[]{this.primordiumAmount}));
            return list;
        }
        return Collections.emptyList();
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (slotIndex == 2 && this.weights.length > 1) {
            int chance = this.weights[this.out.get(0).indexOf(ingredient)] * 100 / this.totalWeight;
            if (chance == 0) {
                tooltip.add(I18n.func_135052_a((String)CHANCE_LOW, (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)CHANCE, (Object[])new Object[]{chance}));
            }
        }
    }
}

