/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.SoldererManager;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.solderer")
@ZenRegister
public class Solderer {
    private static SoldererManager.SoldererRecipe recipe(IItemStack pattern, IItemStack additive, IItemStack output, int gold, int time) {
        return new SoldererManager.SoldererRecipe(CraftTweakerHelper.toItemStack(pattern), CraftTweakerHelper.toItemStack(additive), CraftTweakerHelper.toItemStack(output), gold, time);
    }

    private static SoldererManager.SoldererRecipe recipe(IItemStack pattern, IItemStack output, int gold, int time) {
        return Solderer.recipe(pattern, null, output, gold, time);
    }

    @ZenMethod
    public static void addRecipe(IItemStack pattern, IItemStack additive, IItemStack output, int gold, @Optional int time) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (gold <= 0) {
            throw new IllegalArgumentException("Gold amount must be positive");
        }
        if (gold > Config.soldererMaxGold) {
            throw new IllegalArgumentException("Recipe requires more Gold than the Solderer is configured to hold");
        }
        if (time <= 0) {
            time = Config.soldererProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(Solderer.recipe(pattern, additive, output, gold, time)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack pattern, IItemStack output, int gold, @Optional int time) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (gold <= 0) {
            throw new IllegalArgumentException("Gold amount must be positive");
        }
        if (gold > Config.soldererMaxGold) {
            throw new IllegalArgumentException("Recipe requires more Gold than the Solderer is configured to hold");
        }
        if (time <= 0) {
            time = Config.soldererProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(Solderer.recipe(pattern, output, gold, time)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack pattern, IItemStack additive) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(pattern), CraftTweakerHelper.toItemStack(additive)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            SoldererManager.removeAll();
        }

        public String describe() {
            return "Removing all Solderer recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack pattern;
        private final ItemStack additive;

        public Remove(ItemStack pattern, ItemStack additive) {
            this.pattern = pattern;
            this.additive = additive;
        }

        public void apply() {
            SoldererManager.removeRecipe(this.pattern, this.additive, Integer.MAX_VALUE);
        }

        public String describe() {
            return "Removing Solderer recipe with input " + this.pattern.func_82833_r() + " + " + this.additive.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final SoldererManager.SoldererRecipe recipe;

        public Add(SoldererManager.SoldererRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            SoldererManager.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Solderer recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

