/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.PrimordialisReactorManager;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.primordialisreactor")
@ZenRegister
public class PrimordialisReactor {
    @ZenMethod
    public static void addInput(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void addInput(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new AddOre(in.getName()));
    }

    @ZenMethod
    public static void removeInput(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void removeInput(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(in.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            PrimordialisReactorManager.removeAll();
        }

        public String describe() {
            return "Removing all Primordialis Reactor inputs";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String ore;

        public RemoveOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            PrimordialisReactorManager.removeInput(this.ore);
        }

        public String describe() {
            return "Removing Primordialis Reactor input " + this.ore;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            PrimordialisReactorManager.removeInput(this.stack);
        }

        public String describe() {
            return "Removing Primordialis Reactor input " + this.stack.func_82833_r();
        }
    }

    private static class AddOre
    implements IAction {
        private final String ore;

        public AddOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            PrimordialisReactorManager.addInput(this.ore);
        }

        public String describe() {
            return "Adding Primordialis Reactor input " + this.ore;
        }
    }

    private static class Add
    implements IAction {
        private final ItemStack stack;

        public Add(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            PrimordialisReactorManager.addInput(this.stack);
        }

        public String describe() {
            return "Adding Primordialis Reactor input " + this.stack.func_82833_r();
        }
    }
}

