/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.OreRefineryManager;
import lykrast.prodigytech.common.recipe.SimpleRecipeSecondaryOutput;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.orerefinery")
@ZenRegister
public class OreRefinery {
    private static SimpleRecipeSecondaryOutput recipe(IItemStack in, IItemStack out, int time) {
        return new SimpleRecipeSecondaryOutput(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), time);
    }

    private static SimpleRecipeSecondaryOutput recipe(IItemStack in, IItemStack out, IItemStack sec, float chance, int time) {
        return new SimpleRecipeSecondaryOutput(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), CraftTweakerHelper.toItemStack(sec), time, chance);
    }

    private static SimpleRecipeSecondaryOutput recipe(IOreDictEntry in, IItemStack out, int time) {
        return new SimpleRecipeSecondaryOutput(in.getName(), CraftTweakerHelper.toItemStack(out), time);
    }

    private static SimpleRecipeSecondaryOutput recipe(IOreDictEntry in, IItemStack out, IItemStack sec, float chance, int time) {
        return new SimpleRecipeSecondaryOutput(in.getName(), CraftTweakerHelper.toItemStack(out), CraftTweakerHelper.toItemStack(sec), time, chance);
    }

    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.oreRefineryProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(OreRefinery.recipe(in, out, time)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, IItemStack sec, @Optional float chance, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (chance <= 0.0f) {
            chance = Config.oreRefineryChance;
        }
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        if (time <= 0) {
            time = Config.oreRefineryProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(OreRefinery.recipe(in, out, sec, chance, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.oreRefineryProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(OreRefinery.recipe(in, out, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, IItemStack sec, @Optional float chance, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (chance <= 0.0f) {
            chance = Config.oreRefineryChance;
        }
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        if (time <= 0) {
            time = Config.oreRefineryProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(OreRefinery.recipe(in, out, sec, chance, time)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void removeRecipe(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(in.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            OreRefineryManager.INSTANCE.removeAll();
        }

        public String describe() {
            return "Removing all Ore Refinery recipes";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String ore;

        public RemoveOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            OreRefineryManager.INSTANCE.removeOreRecipe(this.ore);
        }

        public String describe() {
            return "Removing Ore Refinery recipe with input " + this.ore;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            OreRefineryManager.INSTANCE.removeRecipe(this.stack);
        }

        public String describe() {
            return "Removing Ore Refinery recipe with input " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final SimpleRecipeSecondaryOutput recipe;

        public Add(SimpleRecipeSecondaryOutput recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            OreRefineryManager.INSTANCE.addRecipe(this.recipe);
        }

        public String describe() {
            String message = "Adding Ore Refinery recipe for " + this.recipe.getOutput().func_82833_r();
            if (this.recipe.hasSecondaryOutput()) {
                message = message + " + " + this.recipe.getSecondaryOutput().func_82833_r();
            }
            return message;
        }
    }
}

