/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.MagneticReassemblerManager;
import lykrast.prodigytech.common.recipe.SimpleRecipe;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.magneticreassembler")
@ZenRegister
public class MagneticReassembler {
    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.magneticReassemblerProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.simpleRecipe(in, out, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.magneticReassemblerProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.simpleRecipe(in, out, time)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void removeRecipe(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(in.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            MagneticReassemblerManager.INSTANCE.removeAll();
        }

        public String describe() {
            return "Removing all Magnetic Reassembler recipes";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String ore;

        public RemoveOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            MagneticReassemblerManager.INSTANCE.removeOreRecipe(this.ore);
        }

        public String describe() {
            return "Removing Magnetic Reassembler recipe with input " + this.ore;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            MagneticReassemblerManager.INSTANCE.removeRecipe(this.stack);
        }

        public String describe() {
            return "Removing Magnetic Reassembler recipe with input " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final SimpleRecipe recipe;

        public Add(SimpleRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            MagneticReassemblerManager.INSTANCE.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Magnetic Reassembler recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

