/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.HeatSawmillManager;
import lykrast.prodigytech.common.recipe.SimpleRecipeSecondaryOutput;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.heatsawmill")
@ZenRegister
public class HeatSawmill {
    private static SimpleRecipeSecondaryOutput recipe(IItemStack in, IItemStack out, int time) {
        return new SimpleRecipeSecondaryOutput(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), time);
    }

    private static SimpleRecipeSecondaryOutput recipe(IItemStack in, IItemStack out, IItemStack sec, int time) {
        return new SimpleRecipeSecondaryOutput(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), CraftTweakerHelper.toItemStack(sec), time);
    }

    private static SimpleRecipeSecondaryOutput recipe(IOreDictEntry in, IItemStack out, int time) {
        return new SimpleRecipeSecondaryOutput(in.getName(), CraftTweakerHelper.toItemStack(out), time);
    }

    private static SimpleRecipeSecondaryOutput recipe(IOreDictEntry in, IItemStack out, IItemStack sec, int time) {
        return new SimpleRecipeSecondaryOutput(in.getName(), CraftTweakerHelper.toItemStack(out), CraftTweakerHelper.toItemStack(sec), time);
    }

    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.heatSawmillProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(HeatSawmill.recipe(in, out, time)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, IItemStack sec, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.heatSawmillProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(HeatSawmill.recipe(in, out, sec, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.heatSawmillProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(HeatSawmill.recipe(in, out, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, IItemStack sec, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (time <= 0) {
            time = Config.heatSawmillProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(HeatSawmill.recipe(in, out, sec, time)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void removeRecipe(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(in.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            HeatSawmillManager.INSTANCE.removeAll();
        }

        public String describe() {
            return "Removing all Heat Sawmill recipes";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String ore;

        public RemoveOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            HeatSawmillManager.INSTANCE.removeOreRecipe(this.ore);
        }

        public String describe() {
            return "Removing Heat Sawmill recipe with input " + this.ore;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            HeatSawmillManager.INSTANCE.removeRecipe(this.stack);
        }

        public String describe() {
            return "Removing Heat Sawmill recipe with input " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final SimpleRecipeSecondaryOutput recipe;

        public Add(SimpleRecipeSecondaryOutput recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            HeatSawmillManager.INSTANCE.addRecipe(this.recipe);
        }

        public String describe() {
            String message = "Adding Heat Sawmill recipe for " + this.recipe.getOutput().func_82833_r();
            if (this.recipe.hasSecondaryOutput()) {
                message = message + " + " + this.recipe.getSecondaryOutput().func_82833_r();
            }
            return message;
        }
    }
}

