/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.ExplosionFurnaceManager;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.explosionfurnace.explosives")
@ZenRegister
public class ExplosionFurnaceExplosives {
    @ZenMethod
    public static void add(IItemStack explosive, int amount) {
        if (explosive == null) {
            throw new IllegalArgumentException("Explosive cannot be null");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("EP amount must be positive");
        }
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.toItemStack(explosive), amount));
    }

    @ZenMethod
    public static void add(IOreDictEntry explosive, int amount) {
        if (explosive == null) {
            throw new IllegalArgumentException("Explosive cannot be null");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("EP amount must be positive");
        }
        CraftTweakerAPI.apply((IAction)new AddOre(explosive.getName(), amount));
    }

    @ZenMethod
    public static void remove(IItemStack explosive) {
        if (explosive == null) {
            throw new IllegalArgumentException("Explosive cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(explosive)));
    }

    @ZenMethod
    public static void remove(IOreDictEntry explosive) {
        if (explosive == null) {
            throw new IllegalArgumentException("Explosive cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(explosive.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            ExplosionFurnaceManager.removeAllExplosives();
        }

        public String describe() {
            return "Removing all Explosion Furnace explosives";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String explosive;

        public RemoveOre(String explosive) {
            this.explosive = explosive;
        }

        public void apply() {
            ExplosionFurnaceManager.removeExplosive(this.explosive);
        }

        public String describe() {
            return "Removing Explosion Furnace explosive " + this.explosive;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack explosive;

        public Remove(ItemStack explosive) {
            this.explosive = explosive;
        }

        public void apply() {
            ExplosionFurnaceManager.removeExplosive(this.explosive);
        }

        public String describe() {
            return "Removing Explosion Furnace explosive " + this.explosive.func_82833_r();
        }
    }

    private static class AddOre
    implements IAction {
        private final String explosive;
        private final int amount;

        public AddOre(String explosive, int amount) {
            this.explosive = explosive;
            this.amount = amount;
        }

        public void apply() {
            ExplosionFurnaceManager.addExplosive(this.explosive, this.amount);
        }

        public String describe() {
            return "Adding Explosion Furnace explosive " + this.explosive;
        }
    }

    private static class Add
    implements IAction {
        private final ItemStack explosive;
        private final int amount;

        public Add(ItemStack explosive, int amount) {
            this.explosive = explosive;
            this.amount = amount;
        }

        public void apply() {
            ExplosionFurnaceManager.addExplosive(this.explosive, this.amount);
        }

        public String describe() {
            return "Adding Explosion Furnace explosive " + this.explosive.func_82833_r();
        }
    }
}

