/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.ExplosionFurnaceManager;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.explosionfurnace.dampeners")
@ZenRegister
public class ExplosionFurnaceDampeners {
    @ZenMethod
    public static void add(IItemStack dampener, int amount) {
        if (dampener == null) {
            throw new IllegalArgumentException("Dampener cannot be null");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("EP amount must be positive");
        }
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerHelper.toItemStack(dampener), amount));
    }

    @ZenMethod
    public static void add(IOreDictEntry dampener, int amount) {
        if (dampener == null) {
            throw new IllegalArgumentException("Dampener cannot be null");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("EP amount must be positive");
        }
        CraftTweakerAPI.apply((IAction)new AddOre(dampener.getName(), amount));
    }

    @ZenMethod
    public static void remove(IItemStack dampener) {
        if (dampener == null) {
            throw new IllegalArgumentException("Dampener cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(dampener)));
    }

    @ZenMethod
    public static void remove(IOreDictEntry dampener) {
        if (dampener == null) {
            throw new IllegalArgumentException("Dampener cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(dampener.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            ExplosionFurnaceManager.removeAllDampeners();
        }

        public String describe() {
            return "Removing all Explosion Furnace dampeners";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String dampener;

        public RemoveOre(String dampener) {
            this.dampener = dampener;
        }

        public void apply() {
            ExplosionFurnaceManager.removeDampener(this.dampener);
        }

        public String describe() {
            return "Removing Explosion Furnace dampener " + this.dampener;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack dampener;

        public Remove(ItemStack dampener) {
            this.dampener = dampener;
        }

        public void apply() {
            ExplosionFurnaceManager.removeDampener(this.dampener);
        }

        public String describe() {
            return "Removing Explosion Furnace dampener " + this.dampener.func_82833_r();
        }
    }

    private static class AddOre
    implements IAction {
        private final String dampener;
        private final int amount;

        public AddOre(String dampener, int amount) {
            this.dampener = dampener;
            this.amount = amount;
        }

        public void apply() {
            ExplosionFurnaceManager.addDampener(this.dampener, this.amount);
        }

        public String describe() {
            return "Adding Explosion Furnace dampener " + this.dampener;
        }
    }

    private static class Add
    implements IAction {
        private final ItemStack dampener;
        private final int amount;

        public Add(ItemStack dampener, int amount) {
            this.dampener = dampener;
            this.amount = amount;
        }

        public void apply() {
            ExplosionFurnaceManager.addDampener(this.dampener, this.amount);
        }

        public String describe() {
            return "Adding Explosion Furnace dampener " + this.dampener.func_82833_r();
        }
    }
}

