/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.ExplosionFurnaceManager;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.explosionfurnace.recipes")
@ZenRegister
public class ExplosionFurnace {
    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IItemStack in, IItemStack out, int ep) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), ep);
    }

    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IOreDictEntry in, IItemStack out, int ep) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(in.getName(), in.getAmount(), CraftTweakerHelper.toItemStack(out), ep);
    }

    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IItemStack in, IItemStack out, int ep, IItemStack reagent, int craftPerReagent) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), ep, CraftTweakerHelper.toItemStack(reagent), craftPerReagent);
    }

    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IOreDictEntry in, IItemStack out, int ep, IItemStack reagent, int craftPerReagent) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(in.getName(), in.getAmount(), CraftTweakerHelper.toItemStack(out), ep, CraftTweakerHelper.toItemStack(reagent), craftPerReagent);
    }

    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IItemStack in, IItemStack out, int ep, IOreDictEntry reagent, int craftPerReagent) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(CraftTweakerHelper.toItemStack(in), CraftTweakerHelper.toItemStack(out), ep, reagent.getName(), craftPerReagent);
    }

    private static ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe(IOreDictEntry in, IItemStack out, int ep, IOreDictEntry reagent, int craftPerReagent) {
        return new ExplosionFurnaceManager.ExplosionFurnaceRecipe(in.getName(), in.getAmount(), CraftTweakerHelper.toItemStack(out), ep, reagent.getName(), craftPerReagent);
    }

    @ZenMethod
    public static void addRecipe(IIngredient in, IItemStack out, int ep) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (ep <= 0) {
            throw new IllegalArgumentException("EP amount must be positive and non null");
        }
        if (in instanceof IItemStack) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IItemStack)in, out, ep)));
        } else if (in instanceof IOreDictEntry) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IOreDictEntry)in, out, ep)));
        } else if (in instanceof IOreDictEntry) {
            throw new IllegalArgumentException("Input must an ItemStack or an OreDictEntry");
        }
    }

    @ZenMethod
    public static void addRecipe(IIngredient in, IItemStack out, int ep, IItemStack reagent, int craftPerReagent) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (reagent == null) {
            throw new IllegalArgumentException("Reagent cannot be null with the extra reagent arguments");
        }
        if (ep <= 0) {
            throw new IllegalArgumentException("EP amount must be positive and non null");
        }
        if (craftPerReagent <= 0) {
            throw new IllegalArgumentException("Craft per reagent must be positive and non null");
        }
        if (in instanceof IItemStack) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IItemStack)in, out, ep, reagent, craftPerReagent)));
        } else if (in instanceof IOreDictEntry) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IOreDictEntry)in, out, ep, reagent, craftPerReagent)));
        } else if (in instanceof IOreDictEntry) {
            throw new IllegalArgumentException("Input must an ItemStack or an OreDictEntry");
        }
    }

    @ZenMethod
    public static void addRecipe(IIngredient in, IItemStack out, int ep, IOreDictEntry reagent, int craftPerReagent) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (reagent == null) {
            throw new IllegalArgumentException("Reagent cannot be null with the extra reagent arguments");
        }
        if (ep <= 0) {
            throw new IllegalArgumentException("EP amount must be positive and non null");
        }
        if (craftPerReagent <= 0) {
            throw new IllegalArgumentException("Craft per reagent must be positive and non null");
        }
        if (in instanceof IItemStack) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IItemStack)in, out, ep, reagent, craftPerReagent)));
        } else if (in instanceof IOreDictEntry) {
            CraftTweakerAPI.apply((IAction)new Add(ExplosionFurnace.recipe((IOreDictEntry)in, out, ep, reagent, craftPerReagent)));
        } else if (in instanceof IOreDictEntry) {
            throw new IllegalArgumentException("Input must an ItemStack or an OreDictEntry");
        }
    }

    @ZenMethod
    public static void removeRecipeByOutput(IItemStack out) {
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(out)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            ExplosionFurnaceManager.removeAllRecipes();
        }

        public String describe() {
            return "Removing all Explosion Furnace recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            ExplosionFurnaceManager.removeRecipeByOutput(this.stack);
        }

        public String describe() {
            return "Removing Explosion Furnace recipe for " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe;

        public Add(ExplosionFurnaceManager.ExplosionFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            ExplosionFurnaceManager.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Explosion Furnace recipe for " + this.recipe.getOutput().func_82833_r();
        }
    }
}

