/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import lykrast.prodigytech.common.compat.crafttweaker.CraftTweakerHelper;
import lykrast.prodigytech.common.recipe.AtomicReshaperManager;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.prodigytech.atomicreshaper")
@ZenRegister
public class AtomicReshaper {
    private static AtomicReshaperManager.AtomicReshaperRecipe recipe(IItemStack in, IItemStack out, int primordium, int time) {
        return new AtomicReshaperManager.AtomicReshaperRecipe(CraftTweakerHelper.toItemStack(in), time, primordium, CraftTweakerHelper.toItemStack(out));
    }

    private static AtomicReshaperManager.AtomicReshaperRecipe recipe(IOreDictEntry in, IItemStack out, int primordium, int time) {
        return new AtomicReshaperManager.AtomicReshaperRecipe(in.getName(), time, primordium, CraftTweakerHelper.toItemStack(out));
    }

    private static AtomicReshaperManager.AtomicReshaperRecipe recipe(IItemStack in, int primordium, int time, IItemStack[] outputs, int[] weights) {
        Object[] args = new Object[outputs.length * 2];
        for (int i = 0; i < outputs.length; ++i) {
            args[2 * i] = CraftTweakerHelper.toItemStack(outputs[i]);
            args[2 * i + 1] = weights[i];
        }
        return new AtomicReshaperManager.AtomicReshaperRecipe(CraftTweakerHelper.toItemStack(in), time, primordium, args);
    }

    @ZenMethod
    public static void addRecipe(IItemStack in, IItemStack out, int primordium, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (primordium <= 0) {
            throw new IllegalArgumentException("Primordium unit amount must be positive");
        }
        if (primordium > Config.atomicReshaperMaxPrimordium * 100) {
            throw new IllegalArgumentException("Recipe requires more Primordium units than the Atomic Reshaper is configured to hold");
        }
        if (primordium > (Config.atomicReshaperMaxPrimordium - 1) * 100) {
            CraftTweakerAPI.logWarning((String)("Recipe requires too many Primordium units to be reliably made, consider reducing it to " + (Config.atomicReshaperMaxPrimordium - 1) * 100 + " or less or increase the Atomic Reshaper's Primordium capacity"));
        }
        if (time <= 0) {
            time = Config.atomicReshaperProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(AtomicReshaper.recipe(in, out, primordium, time)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry in, IItemStack out, int primordium, @Optional int time) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output cannot be null");
        }
        if (primordium <= 0) {
            throw new IllegalArgumentException("Primordium unit amount must be positive");
        }
        if (primordium > Config.atomicReshaperMaxPrimordium * 100) {
            throw new IllegalArgumentException("Recipe requires more Primordium units than the Atomic Reshaper is configured to hold");
        }
        if (primordium > (Config.atomicReshaperMaxPrimordium - 1) * 100) {
            CraftTweakerAPI.logWarning((String)("Recipe requires too many Primordium units to be reliably made, consider reducing it to " + (Config.atomicReshaperMaxPrimordium - 1) * 100 + " or less or increase the Atomic Reshaper's Primordium capacity"));
        }
        if (time <= 0) {
            time = Config.atomicReshaperProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(AtomicReshaper.recipe(in, out, primordium, time)));
    }

    @ZenMethod
    public static void addRecipeMulti(IItemStack in, int primordium, int time, IItemStack[] outputs, @Optional int[] weights) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Output array cannot be null");
        }
        if (weights == null) {
            weights = new int[outputs.length];
            Arrays.fill(weights, 1);
        } else if (weights.length != outputs.length) {
            throw new IllegalArgumentException("Output array and weight array must have the same length");
        }
        if (primordium <= 0) {
            throw new IllegalArgumentException("Primordium unit amount must be positive");
        }
        if (primordium > Config.atomicReshaperMaxPrimordium * 100) {
            throw new IllegalArgumentException("Recipe requires more Primordium units than the Atomic Reshaper is configured to hold");
        }
        if (primordium > (Config.atomicReshaperMaxPrimordium - 1) * 100) {
            CraftTweakerAPI.logWarning((String)("Recipe requires too many Primordium units to be reliably made, consider reducing it to " + (Config.atomicReshaperMaxPrimordium - 1) * 100 + " or less or increase the Atomic Reshaper's Primordium capacity"));
        }
        if (time <= 0) {
            time = Config.atomicReshaperProcessTime;
        }
        CraftTweakerAPI.apply((IAction)new Add(AtomicReshaper.recipe(in, primordium, time, outputs, weights)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toItemStack(in)));
    }

    @ZenMethod
    public static void removeRecipe(IOreDictEntry in) {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        CraftTweakerAPI.apply((IAction)new RemoveOre(in.getName()));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            AtomicReshaperManager.INSTANCE.removeAll();
        }

        public String describe() {
            return "Removing all Atomic Reshaper recipes";
        }
    }

    private static class RemoveOre
    implements IAction {
        private final String ore;

        public RemoveOre(String ore) {
            this.ore = ore;
        }

        public void apply() {
            AtomicReshaperManager.INSTANCE.removeOreRecipe(this.ore);
        }

        public String describe() {
            return "Removing Atomic Reshaper recipe with input " + this.ore;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        public Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            AtomicReshaperManager.INSTANCE.removeRecipe(this.stack);
        }

        public String describe() {
            return "Removing Atomic Reshaper recipe with input " + this.stack.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final AtomicReshaperManager.AtomicReshaperRecipe recipe;

        public Add(AtomicReshaperManager.AtomicReshaperRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AtomicReshaperManager.INSTANCE.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Atomic Reshaper recipe with input " + this.recipe.getInput().func_82833_r();
        }
    }
}

