/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.compat;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import lykrast.prodigytech.client.gui.TheOneProbeRenderer;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.capability.HotAirMachine;
import lykrast.prodigytech.common.capability.IHotAir;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.tileentity.TileAeroheaterTartaric;
import lykrast.prodigytech.common.tileentity.TileWormholeFunnel;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ProdigyTechTOP
implements Function<ITheOneProbe, Void> {
    private static int elementid;
    public static final String WORMHOLE_LINKED = "status.prodigytech.wormhole_linker.linked";
    public static final String WORMHOLE_UNLINKED = "status.prodigytech.wormhole_linker.unlinked";

    @Override
    public Void apply(ITheOneProbe probe) {
        elementid = probe.registerElementFactory(TextFormatInt::new);
        probe.registerProvider((IProbeInfoProvider)new HotAirInfoProvider());
        probe.registerProvider((IProbeInfoProvider)new ProgressInfoProvider());
        return null;
    }

    public static String readStringUTF8(ByteBuf dataIn) {
        int s = dataIn.readInt();
        if (s == -1) {
            return null;
        }
        if (s == 0) {
            return "";
        }
        byte[] dst = new byte[s];
        dataIn.readBytes(dst);
        return new String(dst, StandardCharsets.UTF_8);
    }

    public static void writeStringUTF8(ByteBuf dataOut, String str) {
        if (str == null) {
            dataOut.writeInt(-1);
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        if (bytes.length > 0) {
            dataOut.writeBytes(bytes);
        }
    }

    public static class TextFormatInt
    implements IElement {
        private String text;
        private int value;

        public TextFormatInt(String text, int value) {
            this.text = text;
            this.value = value;
        }

        public TextFormatInt(ByteBuf buf) {
            this.value = buf.readInt();
            this.text = ProdigyTechTOP.readStringUTF8(buf);
        }

        public void render(int x, int y) {
            TheOneProbeRenderer.renderTextFormatted(this.text, this.value, x, y);
        }

        public int getWidth() {
            return TheOneProbeRenderer.getWidthFormatted(this.text, this.value);
        }

        public int getHeight() {
            return 10;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.value);
            ProdigyTechTOP.writeStringUTF8(buf, this.text);
        }

        public int getID() {
            return elementid;
        }
    }

    public static class ProgressInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "prodigytech:progress";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            IProcessing casted;
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileAeroheaterTartaric) {
                TileAeroheaterTartaric tartaric = (TileAeroheaterTartaric)te;
                if (tartaric.isBurningSomething()) {
                    probeInfo.progress(tartaric.getBurnLeft(), tartaric.getBurnMax(), probeInfo.defaultProgressStyle().height(6).showText(false).filledColor(-1992448).alternateFilledColor(-1992448));
                    probeInfo.progress(tartaric.getStokerLeft(), tartaric.getStokerMax(), probeInfo.defaultProgressStyle().height(6).showText(false).filledColor(-8868664).alternateFilledColor(-8868664));
                }
            } else if (te instanceof IProcessing && (casted = (IProcessing)te).isProcessing()) {
                int amount = casted.invertDisplay() ? 100 * casted.getProgressLeft() / casted.getMaxProgress() : 100 * (casted.getMaxProgress() - casted.getProgressLeft()) / casted.getMaxProgress();
                probeInfo.progress(amount, 100, probeInfo.defaultProgressStyle().height(12).suffix("%"));
            }
        }
    }

    public static class HotAirInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "prodigytech:hotair";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            TileEntity te = world.func_175625_s(data.getPos());
            if (te instanceof TileWormholeFunnel) {
                TileWormholeFunnel funnel = (TileWormholeFunnel)te;
                probeInfo.text("{*" + (funnel.isLinked() ? ProdigyTechTOP.WORMHOLE_LINKED : ProdigyTechTOP.WORMHOLE_UNLINKED) + "*}");
                if (funnel.isInput()) {
                    if (funnel.getOutAirTemperature() > 0) {
                        probeInfo.element((IElement)new TextFormatInt("container.prodigytech.temperature.input", funnel.getOutAirTemperature()));
                    }
                } else if (funnel.getOutAirTemperature() > 0) {
                    probeInfo.element((IElement)new TextFormatInt("container.prodigytech.temperature.output", funnel.getOutAirTemperature()));
                }
            } else if (te != null && te.hasCapability(CapabilityHotAir.HOT_AIR, null)) {
                HotAirMachine casted;
                IHotAir hotair = (IHotAir)te.getCapability(CapabilityHotAir.HOT_AIR, null);
                if (hotair instanceof HotAirMachine && (casted = (HotAirMachine)hotair).getInAirTemperature() > 0) {
                    probeInfo.element((IElement)new TextFormatInt("container.prodigytech.temperature.input", casted.getInAirTemperature()));
                }
                if (hotair.getOutAirTemperature() > 0) {
                    probeInfo.element((IElement)new TextFormatInt("container.prodigytech.temperature.output", hotair.getOutAirTemperature()));
                }
            }
        }
    }
}

