/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.capability;

import lykrast.prodigytech.common.capability.HotAirChangeable;
import lykrast.prodigytech.common.tileentity.IProcessing;
import lykrast.prodigytech.common.util.TemperatureHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HotAirMachine
extends HotAirChangeable {
    protected IProcessing machine;
    protected int temperatureOut;
    protected float outputMultiplier;

    public HotAirMachine(IProcessing machine, float outputMultiplier) {
        this.temperatureOut = this.temperature;
        this.machine = machine;
        this.outputMultiplier = outputMultiplier;
    }

    public int getInAirTemperature() {
        return this.temperature;
    }

    @Override
    public int getOutAirTemperature() {
        return this.temperatureOut;
    }

    public void setOutAirTemperature(int value) {
        this.temperatureOut = value;
    }

    public void updateInTemperature(World world, BlockPos pos) {
        this.temperature = TemperatureHelper.getBlockTemp(world, pos.func_177977_b());
    }

    public void updateOutTemperature() {
        this.temperatureOut = this.machine.isProcessing() ? (int)((float)this.temperature * this.outputMultiplier) : this.temperature;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Temperature", this.temperature);
        compound.func_74768_a("TemperatureOut", this.temperatureOut);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.temperatureOut = nbt.func_74762_e("TemperatureOut");
    }
}

