/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.block;

import lykrast.prodigytech.common.block.BlockGeneric;
import lykrast.prodigytech.common.block.ICustomItemBlock;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.init.ModBlocks;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.item.ItemBlockInfoShift;
import lykrast.prodigytech.common.network.PacketWormholeDisplay;
import lykrast.prodigytech.common.tileentity.TileWormholeFunnel;
import lykrast.prodigytech.common.util.TemperatureHelper;
import lykrast.prodigytech.core.ProdigyTech;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockWormholeFunnel
extends BlockGeneric
implements ITileEntityProvider,
ICustomItemBlock {
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    protected static final AxisAlignedBB LOWER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB UPPER = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockWormholeFunnel(float hardness, float resistance, int harvestLevel) {
        super(Material.field_151573_f, SoundType.field_185852_e, hardness, resistance, "pickaxe", harvestLevel);
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileWormholeFunnel tile;
        Item item = playerIn.func_184586_b(hand).func_77973_b();
        if (item == ModItems.wormholeLinker || item instanceof ItemBlock) {
            return false;
        }
        if (!worldIn.field_72995_K && (tile = BlockWormholeFunnel.getTileEntity((IBlockAccess)worldIn, pos)) != null && tile.isLinked() && tile.isActive() && playerIn instanceof EntityPlayerMP) {
            BlockPos linked = tile.getLinkedPos();
            ProdigyTech.networkChannel.sendTo((IMessage)new PacketWormholeDisplay(pos, linked), (EntityPlayerMP)playerIn);
        }
        return true;
    }

    public static void setActive(boolean active, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.wormholeFunnel && (Boolean)state.func_177229_b((IProperty)ACTIVE) != active) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileWormholeFunnel tile = new TileWormholeFunnel();
        tile.setDown((meta & 1) == 0);
        return tile;
    }

    public static TileWormholeFunnel getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWormholeFunnel) {
            return (TileWormholeFunnel)tile;
        }
        return null;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            TemperatureHelper.hotAirDamage(entityIn, BlockWormholeFunnel.getTileEntity((IBlockAccess)worldIn, pos).getCapability(CapabilityHotAir.HOT_AIR, EnumFacing.UP));
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileWormholeFunnel tile = BlockWormholeFunnel.getTileEntity((IBlockAccess)worldIn, pos);
        tile.destroyLink(true);
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing == EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(true));
        }
        if (facing == EnumFacing.DOWN) {
            return this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf((double)hitY <= 0.5));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)DOWN) != false ? LOWER : UPPER;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf((meta & 1) == 0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 2) == 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 2;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, ACTIVE});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN && ((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue() || face == EnumFacing.UP && !((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockInfoShift(this);
    }
}

