/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.block;

import lykrast.prodigytech.common.block.BlockGeneric;
import lykrast.prodigytech.common.block.ICustomItemBlock;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.item.ItemBlockMachineHotAir;
import lykrast.prodigytech.common.tileentity.TileSolderer;
import lykrast.prodigytech.common.util.TemperatureHelper;
import lykrast.prodigytech.core.ProdigyTech;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSolderer
extends BlockGeneric
implements ITileEntityProvider,
ICustomItemBlock {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockSolderer(float hardness, float resistance, int harvestLevel) {
        super(Material.field_151573_f, SoundType.field_185852_e, hardness, resistance, "pickaxe", harvestLevel);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileSolderer();
    }

    private TileSolderer getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileSolderer) {
            return (TileSolderer)tile;
        }
        return null;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        TemperatureHelper.hotAirDamage(entityIn, this.getTileEntity((IBlockAccess)worldIn, pos).getCapability(CapabilityHotAir.HOT_AIR, EnumFacing.UP));
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileSolderer tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            playerIn.openGui((Object)ProdigyTech.instance, 5, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            playerIn.field_71070_bA.func_75142_b();
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileSolderer tile = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getTileEntity((IBlockAccess)worldIn, pos).getComparatorOutput();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockMachineHotAir(this, 125, 75);
    }
}

