/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import lykrast.prodigytech.common.block.BlockGeneric;
import lykrast.prodigytech.common.block.ICustomItemBlock;
import lykrast.prodigytech.common.block.ICustomStateMapper;
import lykrast.prodigytech.common.init.ModItems;
import lykrast.prodigytech.common.util.AABBUtil;
import lykrast.prodigytech.common.util.Config;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnergionCrystal
extends BlockGeneric
implements ICustomStateMapper,
ICustomItemBlock {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
    public static final PropertyBool DEFUSED = PropertyBool.func_177716_a((String)"defused");
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{AABBUtil.getCenteredDownSquareFromPixels(6.0, 4.0), AABBUtil.getCenteredDownSquareFromPixels(8.0, 6.0), AABBUtil.getCenteredDownSquareFromPixels(12.0, 9.0), AABBUtil.getCenteredDownSquareFromPixels(14.0, 9.0), AABBUtil.getCenteredDownSquareFromPixels(14.0, 12.0), AABBUtil.getCenteredDownSquareFromPixels(14.0, 15.0)};

    public BlockEnergionCrystal(float hardness, float resistance, int harvestLevel) {
        super(Material.field_151576_e, SoundType.field_185853_f, hardness, resistance, "crystalcutter", harvestLevel);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DEFUSED, (Comparable)Boolean.valueOf(false)));
        this.func_149715_a(0.6f);
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        int age = BlockEnergionCrystal.getAge(state);
        if (age < 5 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / Config.energionGrowthSpeed) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.withAge(age + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.energionCrystalSeed;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModItems.energionCrystalSeed);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int age = BlockEnergionCrystal.getAge(state);
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        drops.add((Object)new ItemStack(ModItems.energionCrystalSeed, 1, 0));
        if (age > 0) {
            for (int i = 0; i < age; ++i) {
                drops.add((Object)new ItemStack(ModItems.energionCrystalSeed, 1, 0));
                if (fortune <= 0) continue;
                for (int j = 0; j < fortune; ++j) {
                    if (rand.nextInt(2) != 0) continue;
                    drops.add((Object)new ItemStack(ModItems.energionCrystalSeed, 1, 0));
                }
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public void onBlockExploded(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.explode(worldIn, pos, worldIn.func_180495_p(pos), explosionIn.func_94613_c());
        super.onBlockExploded(worldIn, pos, explosionIn);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean destroyed = super.removedByPlayer(state, world, pos, player, willHarvest);
        if (destroyed && !player.func_184812_l_()) {
            this.explode(world, pos, state, (EntityLivingBase)player);
        }
        return destroyed;
    }

    private void explode(World world, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (!world.field_72995_K) {
            int age = BlockEnergionCrystal.getAge(state);
            if (!this.isDefused(state) && age > 0) {
                for (int i = 0; i < age; ++i) {
                    EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), igniter);
                    entitytntprimed.func_184534_a(5 + 4 * i);
                    world.func_72838_d((Entity)entitytntprimed);
                }
            }
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)).func_177226_a((IProperty)DEFUSED, (Comparable)Boolean.valueOf(false));
    }

    public static int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    private boolean isDefused(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DEFUSED);
    }

    public static void defuse(World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DEFUSED, (Comparable)Boolean.TRUE));
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return BlockEnergionCrystal.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, DEFUSED});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setCustomStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{DEFUSED}).func_178441_a());
    }
}

