/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.common.block;

import lykrast.prodigytech.common.block.BlockGeneric;
import lykrast.prodigytech.common.block.ICustomItemBlock;
import lykrast.prodigytech.common.capability.CapabilityHotAir;
import lykrast.prodigytech.common.item.ItemBlockInfoShift;
import lykrast.prodigytech.common.tileentity.TileAirFunnel;
import lykrast.prodigytech.common.util.TemperatureHelper;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAirFunnel
extends BlockGeneric
implements ITileEntityProvider,
ICustomItemBlock {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockAirFunnel(float hardness, float resistance, int harvestLevel) {
        super(Material.field_151573_f, SoundType.field_185852_e, hardness, resistance, "pickaxe", harvestLevel);
        this.func_149713_g(0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAirFunnel();
    }

    private TileAirFunnel getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAirFunnel) {
            return (TileAirFunnel)tile;
        }
        return null;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        TemperatureHelper.hotAirDamage(entityIn, this.getTileEntity((IBlockAccess)worldIn, pos).getCapability(CapabilityHotAir.HOT_AIR, EnumFacing.UP));
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN || face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBlockInfoShift(this);
    }
}

