/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lykrast.prodigytech.client.gui.GuiInventory;
import lykrast.prodigytech.common.gui.ContainerPrimordialisReactor;
import lykrast.prodigytech.common.tileentity.TilePrimordialisReactor;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.core.ProdigyTech;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiPrimordialisReactor
extends GuiInventory {
    public static final ResourceLocation GUI = ProdigyTech.resource("textures/gui/primordialis_reactor.png");
    protected final IInventory playerInventory;
    protected final TilePrimordialisReactor tile;

    public GuiPrimordialisReactor(InventoryPlayer playerInv, TilePrimordialisReactor tile) {
        super(new ContainerPrimordialisReactor(playerInv, tile));
        this.playerInventory = playerInv;
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TilePrimordialisReactor.isProcessing(this.tile)) {
            int k = this.getFieldScaled(0, 28, 0, Config.primordialisReactorCycleTime * 10);
            this.func_73729_b(this.field_147003_i + 63, this.field_147009_r + 30 + (28 - k), 176, 35 + (28 - k), 12, k + 1);
        }
        int l = this.getFieldScaled(2, 17, 30, 250);
        this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 52 + (17 - l), 176, 17 + (17 - l), 18, l + 1);
        l = this.getFieldScaled(3, 17, 30, 250);
        this.func_73729_b(this.field_147003_i + 92, this.field_147009_r + 16 + (17 - l), 176, 17 + (17 - l), 18, l + 1);
        int m = this.getFieldScaled(1, 62, 0, Config.primordialisReactorRequiredInput);
        this.func_73729_b(this.field_147003_i + 77, this.field_147009_r + 35, 176, 0, m, 17);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    private int getFieldScaled(int index, int pixels, int min, int max) {
        int temp = MathHelper.func_76125_a((int)this.tile.func_174887_a_(index), (int)min, (int)max) - min;
        int interval = max - min;
        return temp != 0 && interval != 0 ? temp * pixels / interval : 0;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.renderTemperatureToolTip(mouseX, mouseY);
    }

    private void renderTemperatureToolTip(int x, int y) {
        if (x >= this.field_147003_i + 92 && x < this.field_147003_i + 110) {
            if (y >= this.field_147009_r + 52 && y < this.field_147009_r + 70) {
                String tooltip = I18n.func_135052_a((String)"container.prodigytech.temperature.input", (Object[])new Object[]{this.tile.func_174887_a_(2)});
                this.drawHoveringText((List)ImmutableList.of((Object)tooltip), x, y, this.field_146289_q);
            } else if (y >= this.field_147009_r + 16 && y < this.field_147009_r + 34) {
                String tooltip = I18n.func_135052_a((String)"container.prodigytech.temperature.output", (Object[])new Object[]{this.tile.func_174887_a_(3)});
                this.drawHoveringText((List)ImmutableList.of((Object)tooltip), x, y, this.field_146289_q);
            }
        }
    }
}

