/*
 * Decompiled with CFR 0.152.
 */
package lykrast.prodigytech.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import lykrast.prodigytech.client.gui.GuiInventory;
import lykrast.prodigytech.common.gui.ContainerAeroheaterTartaric;
import lykrast.prodigytech.common.tileentity.TileAeroheaterTartaric;
import lykrast.prodigytech.common.util.Config;
import lykrast.prodigytech.core.ProdigyTech;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class GuiAeroheaterTartaric
extends GuiInventory {
    public static final ResourceLocation GUI = ProdigyTech.resource("textures/gui/tartaric_aeroheater.png");
    private final IInventory playerInventory;
    private final TileAeroheaterTartaric tile;

    public GuiAeroheaterTartaric(InventoryPlayer playerInv, TileAeroheaterTartaric tile) {
        super(new ContainerAeroheaterTartaric(playerInv, tile));
        this.playerInventory = playerInv;
        this.tile = tile;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TileAeroheaterTartaric.isBurningFuel(this.tile)) {
            k = this.getFuelBurnLeftScaled(13);
            this.func_73729_b(this.field_147003_i + 72, this.field_147009_r + 37 + (13 - k), 176, 13 - k, 14, k + 1);
        }
        if (TileAeroheaterTartaric.isBurningStoker(this.tile)) {
            k = this.getStokerBurnLeftScaled(13);
            this.func_73729_b(this.field_147003_i + 90, this.field_147009_r + 37 + (13 - k), 176, 13 - k, 14, k + 1);
        }
        int l = this.getTemperatureScaled(17, 30, 1000);
        this.func_73729_b(this.field_147003_i + 79, this.field_147009_r + 16 + (17 - l), 176, 14 + (17 - l), 18, l + 1);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    private int getTemperatureScaled(int pixels, int min, int max) {
        int temp = MathHelper.func_76125_a((int)this.tile.func_174887_a_(2), (int)min, (int)max) - min;
        int interval = max - min;
        return temp != 0 && interval != 0 ? temp * pixels / interval : 0;
    }

    private int getFuelBurnLeftScaled(int pixels) {
        int i = this.tile.func_174887_a_(1);
        if (i == 0) {
            i = 200;
        }
        return this.tile.func_174887_a_(0) * pixels / i;
    }

    private int getStokerBurnLeftScaled(int pixels) {
        return Math.min(this.tile.func_174887_a_(3) * pixels / Config.tartaricStokerTime, pixels);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.renderTemperatureToolTip(mouseX, mouseY);
    }

    private void renderTemperatureToolTip(int x, int y) {
        if (x >= this.field_147003_i + 79 && x < this.field_147003_i + 97 && y >= this.field_147009_r + 16 && y < this.field_147009_r + 34) {
            String tooltip = I18n.func_135052_a((String)"container.prodigytech.temperature.output", (Object[])new Object[]{this.tile.func_174887_a_(2)});
            this.drawHoveringText((List)ImmutableList.of((Object)tooltip), x, y, this.field_146289_q);
        }
    }
}

