/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.misc;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TilePrimordialAccretionChamber;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;

public class TilePrimordialAccretionChamberPlaceholder
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    protected int tickCounter = 0;

    public void func_73660_a() {
        TilePrimordialAccretionChamber tile;
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 5 == 0 && (tile = this.findCentralChamber()) != null && !tile.isEssentiaFull()) {
            this.fill();
        }
    }

    protected void fill() {
        TilePrimordialAccretionChamber centralTile = this.findCentralChamber();
        if (centralTile == null) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d())) continue;
            Aspect currentSuction = centralTile.getCurrentSuction();
            if (otherTile.getEssentiaType(face.func_176734_d()) != currentSuction || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(currentSuction, 1, face.func_176734_d());
            int leftover = this.addToContainer(currentSuction, taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("Primordial accretion chamber spilling {} essentia on fill", (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            centralTile.syncTile(false);
            centralTile.func_70296_d();
            if (centralTile.isEssentiaFull()) break;
        }
    }

    @Nullable
    protected TilePrimordialAccretionChamber findCentralChamber() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos searchPos = this.field_174879_c.func_177982_a(i, j, k);
                    TileEntity tile = this.field_145850_b.func_175625_s(searchPos);
                    if (!(tile instanceof TilePrimordialAccretionChamber)) continue;
                    return (TilePrimordialAccretionChamber)tile;
                }
            }
        }
        return null;
    }

    protected boolean isEssentiaPort(EnumFacing face) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        if (tile == null) {
            return false;
        }
        EnumFacing facing = tile.getFacing();
        for (int offset = -1; offset <= 1; ++offset) {
            EnumFacing leftFace = facing.func_176735_f();
            BlockPos leftPos = tile.func_174877_v().func_177967_a(facing, offset).func_177972_a(leftFace);
            if (leftPos.equals((Object)this.field_174879_c)) {
                return face == leftFace;
            }
            EnumFacing rightFace = facing.func_176746_e();
            BlockPos rightPos = tile.func_174877_v().func_177967_a(facing, offset).func_177972_a(rightFace);
            if (!rightPos.equals((Object)this.field_174879_c)) continue;
            return face == rightFace;
        }
        return false;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? 0 : tile.addToContainer(aspect, toAdd);
    }

    public int containerContains(Aspect aspect) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? 0 : tile.containerContains(aspect);
    }

    public boolean doesContainerAccept(Aspect aspect) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? false : tile.doesContainerAccept(aspect);
    }

    public boolean doesContainerContain(AspectList aspectList) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? false : tile.doesContainerContain(aspectList);
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? false : tile.doesContainerContainAmount(aspect, amt);
    }

    public AspectList getAspects() {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? new AspectList() : tile.getAspects();
    }

    public void setAspects(AspectList aspects) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        if (tile != null) {
            tile.setAspects(aspects);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? false : tile.takeFromContainer(aspectList);
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        TilePrimordialAccretionChamber tile = this.findCentralChamber();
        return tile == null ? false : tile.takeFromContainer(aspect, amt);
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face)) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        Aspect type = this.getEssentiaType(face);
        if (type == null) {
            return 0;
        }
        return this.getAspects().getAmount(type);
    }

    public Aspect getEssentiaType(EnumFacing face) {
        AspectList aspects = this.getAspects();
        if (aspects == null || aspects.size() == 0) {
            return null;
        }
        return aspects.getAspectsSortedByAmount()[0];
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        if (this.isEssentiaPort(face)) {
            Aspect type = this.getSuctionType(face);
            return type == null ? 0 : 128;
        }
        return 0;
    }

    public Aspect getSuctionType(EnumFacing face) {
        if (this.isEssentiaPort(face)) {
            TilePrimordialAccretionChamber tile = this.findCentralChamber();
            return tile == null ? null : tile.getCurrentSuction();
        }
        return null;
    }

    public boolean isConnectable(EnumFacing face) {
        return this.isEssentiaPort(face);
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }
}

