/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.misc.OreHelper;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.FXDispatcher;

public class TileOreDiviner
extends TileTW
implements ITickable {
    public static final int SCAN_RANGE = 20;
    protected static final Map<String, Color> ORE_COLORS = new HashMap<String, Color>();
    protected static final Color DEFAULT_ORE_COLOR = new Color(0xC0C0C0);
    protected boolean active = false;
    protected BlockPos target = null;
    protected ItemStack searchStack = null;
    protected int counter = -1;

    public void setTarget(@Nullable BlockPos newTarget) {
        this.target = newTarget;
        this.counter = 0;
    }

    public ItemStack getSearchStack() {
        return this.active ? this.searchStack : ItemStack.field_190927_a;
    }

    public void setSearchStack(ItemStack stack) {
        this.searchStack = stack == null ? null : stack.func_77946_l();
        this.active = this.searchStack != null && !this.searchStack.func_190926_b();
        this.func_70296_d();
        this.syncTile(false);
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.active = compound.func_74767_n("active");
        this.searchStack = new ItemStack(compound.func_74775_l("searchStack"));
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74757_a("active", this.active);
        compound.func_74782_a("searchStack", (NBTBase)this.searchStack.func_77955_b(new NBTTagCompound()));
        return super.writeToTileNBT(compound);
    }

    public void onLoad() {
        this.setSearchStack(ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.active && this.target != null && this.counter % 44 == 0) {
            this.renderPing(this.target);
        }
        if (this.field_145850_b.field_72995_K && this.active && this.counter % 5 == 0) {
            FXDispatcher.INSTANCE.visSparkle(this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(3) - this.field_145850_b.field_73012_v.nextInt(3), this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3), this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(3) - this.field_145850_b.field_73012_v.nextInt(3), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), Aspect.MAGIC.getColor());
        }
        ++this.counter;
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderPing(BlockPos pos) {
        Color color = this.getOreColor(pos);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float colorAvg = (r + g + b) / 3.0f;
        FXDispatcher.GenPart part = new FXDispatcher.GenPart();
        part.age = 44;
        part.redStart = r;
        part.redEnd = r;
        part.greenStart = g;
        part.greenEnd = g;
        part.blueStart = b;
        part.blueEnd = b;
        part.alpha = new float[]{0.0f, 1.0f, 0.8f, 0.0f};
        part.loop = true;
        part.partStart = 240;
        part.partNum = 15;
        part.partInc = 1;
        part.scale = new float[]{9.0f};
        part.layer = colorAvg < 0.25f ? 3 : 2;
        part.grid = 16;
        FXDispatcher.INSTANCE.drawGenericParticles((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.0, 0.0, 0.0, part);
    }

    protected Color getOreColor(BlockPos targetPos) {
        ItemStack stack = ItemStack.field_190927_a;
        IBlockState state = this.field_145850_b.func_180495_p(targetPos);
        if (state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c() != Blocks.field_150357_h) {
            Item item;
            stack = new ItemStack(item, 1, (item = Item.func_150898_a((Block)state.func_177230_c())).func_77614_k() ? state.func_177230_c().func_176201_c(state) : 0);
        }
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return DEFAULT_ORE_COLOR;
        }
        for (String oreName : OreHelper.getOreNames(stack)) {
            if (oreName == null) continue;
            oreName = oreName.toUpperCase();
            for (String key : ORE_COLORS.keySet()) {
                if (!oreName.contains(key)) continue;
                return ORE_COLORS.getOrDefault(key, DEFAULT_ORE_COLOR);
            }
        }
        return DEFAULT_ORE_COLOR;
    }

    static {
        ORE_COLORS.put("IRON", new Color(14200723));
        ORE_COLORS.put("COAL", new Color(0x101010));
        ORE_COLORS.put("REDSTONE", new Color(0xFF0000));
        ORE_COLORS.put("GOLD", new Color(16576075));
        ORE_COLORS.put("LAPIS", new Color(1328572));
        ORE_COLORS.put("DIAMOND", new Color(6155509));
        ORE_COLORS.put("EMERALD", new Color(1564002));
        ORE_COLORS.put("QUARTZ", new Color(0xE5DED5));
        ORE_COLORS.put("SILVER", new Color(14342653));
        ORE_COLORS.put("LEAD", new Color(0x6B6B6B));
        ORE_COLORS.put("TIN", new Color(0xEFEFFB));
        ORE_COLORS.put("COPPER", new Color(16620629));
        ORE_COLORS.put("AMBER", new Color(16626469));
        ORE_COLORS.put("CINNABAR", new Color(10159368));
    }
}

