/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketDimensionalRipperFx;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.IBlockEnabled;
import thaumcraft.common.blocks.IBlockFacing;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;

public class TileDimensionalRipper
extends TileTW
implements IAspectContainer,
IEssentiaTransport,
ITickable {
    private static final int CAPACITY = 250;
    private static final int MIN_FUEL = 50;
    private static final int DISTANCE = 10;
    private static final int PLAY_LINK_EFFECTS = 5;
    protected int amount = 0;
    protected int tickCounter = 0;

    public int getAmount() {
        return this.amount;
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.amount = compound.func_74765_d("essentia");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("essentia", (short)this.amount);
        return compound;
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face)) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.amount;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return Aspect.FLUX;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.amount >= 250 ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return Aspect.FLUX;
    }

    public boolean isConnectable(EnumFacing face) {
        if (this.func_145838_q() instanceof IBlockFacing) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing blockFacing = (EnumFacing)blockState.func_177229_b((IProperty)IBlockFacing.FACING);
            return blockFacing.func_176734_d() == face;
        }
        return false;
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        if (toAdd == 0) {
            return 0;
        }
        if (this.amount >= 250 || aspect != Aspect.FLUX) {
            this.syncTile(false);
            this.func_70296_d();
            return toAdd;
        }
        int added = Math.min(toAdd, 250 - this.amount);
        this.amount += added;
        this.syncTile(false);
        this.func_70296_d();
        return toAdd - added;
    }

    public int containerContains(Aspect aspect) {
        return aspect == Aspect.FLUX ? this.amount : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return aspect == Aspect.FLUX;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return aspect == Aspect.FLUX && this.amount >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.amount > 0) {
            list.add(Aspect.FLUX, this.amount);
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
        if (aspects != null && aspects.size() > 0) {
            this.amount = aspects.getAmount(Aspect.FLUX);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (aspect == Aspect.FLUX && this.amount >= amt) {
            this.amount -= amt;
            this.syncTile(false);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && ++this.tickCounter % 5 == 0) {
            if (this.amount < 250) {
                this.fill();
            }
            this.checkForActivation();
        }
    }

    protected void fill() {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d()) || otherTile.getEssentiaType(face.func_176734_d()) != Aspect.FLUX || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(Aspect.FLUX, 1, face.func_176734_d());
            int leftover = this.addToContainer(Aspect.FLUX, taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("Ripper spilling {} essentia on fill", (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            this.syncTile(false);
            this.func_70296_d();
            if (this.amount >= 250) break;
        }
    }

    protected void checkForActivation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)IBlockFacing.FACING);
        boolean blockEnabled = (Boolean)state.func_177229_b((IProperty)IBlockEnabled.ENABLED);
        BlockPos otherPos = this.field_174879_c.func_177967_a(blockFacing, 10);
        TileEntity otherTe = this.field_145850_b.func_175625_s(otherPos);
        if (otherTe != null && otherTe instanceof TileDimensionalRipper) {
            TileDimensionalRipper otherTile = (TileDimensionalRipper)otherTe;
            IBlockState otherState = this.field_145850_b.func_180495_p(otherPos);
            EnumFacing otherBlockFacing = (EnumFacing)otherState.func_177229_b((IProperty)IBlockFacing.FACING);
            boolean otherBlockEnabled = (Boolean)otherState.func_177229_b((IProperty)IBlockEnabled.ENABLED);
            if (otherBlockFacing == blockFacing.func_176734_d()) {
                this.field_145850_b.func_175641_c(this.func_174877_v(), BlocksTW.DIMENSIONAL_RIPPER, 5, 0);
                if (blockEnabled && otherBlockEnabled && this.amount >= 50 && otherTile.getAmount() >= 50) {
                    BlockPos targetPos = new BlockPos((this.field_174879_c.func_177958_n() + otherPos.func_177958_n()) / 2, (this.field_174879_c.func_177956_o() + otherPos.func_177956_o()) / 2, (this.field_174879_c.func_177952_p() + otherPos.func_177952_p()) / 2);
                    int fuel = Math.min(this.getAmount(), otherTile.getAmount());
                    this.takeFromContainer(Aspect.FLUX, fuel);
                    otherTile.takeFromContainer(Aspect.FLUX, fuel);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketDimensionalRipperFx(this.field_174879_c, targetPos), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketDimensionalRipperFx(otherPos, targetPos), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)otherPos.func_177958_n(), (double)otherPos.func_177956_o(), (double)otherPos.func_177952_p(), 32.0));
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.zap, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_145850_b.func_184133_a(null, otherPos, SoundsTC.zap, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.createRift(targetPos, fuel);
                }
            }
        }
    }

    protected void createRift(BlockPos pos, int fuelUsed) {
        List localRifts = EntityUtils.getEntitiesInRange((World)this.field_145850_b, (BlockPos)pos, null, EntityFluxRift.class, (double)2.0);
        if (localRifts.size() > 0) {
            EntityFluxRift rift = (EntityFluxRift)localRifts.get(0);
            int oldSize = rift.getRiftSize();
            double oldFuel = (double)(oldSize * oldSize) / 3.0;
            int newSize = (int)Math.sqrt((oldFuel + (double)(2 * fuelUsed)) * 3.0);
            rift.setRiftSize(newSize);
            rift.setRiftStability(rift.getRiftStability() - (float)(newSize - oldSize));
        } else if (EntityUtils.getEntitiesInRange((World)this.field_145850_b, (BlockPos)pos, null, EntityFluxRift.class, (double)32.0).size() == 0) {
            EntityFluxRift rift = new EntityFluxRift(this.field_145850_b);
            rift.setRiftSeed(this.field_145850_b.field_73012_v.nextInt());
            rift.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (float)this.field_145850_b.field_73012_v.nextInt(360), 0.0f);
            double size = Math.sqrt((double)(2 * fuelUsed) * 3.0);
            if (this.field_145850_b.func_72838_d((Entity)rift)) {
                rift.setRiftSize((int)size);
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 5) {
            if (this.field_145850_b.field_72995_K) {
                EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IBlockFacing.FACING);
                BlockPos otherPos = this.field_174879_c.func_177967_a(blockFacing, 10);
                FXDispatcher.INSTANCE.visSparkle(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), otherPos.func_177958_n(), otherPos.func_177956_o(), otherPos.func_177952_p(), Aspect.FLUX.getColor());
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

