/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.base;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileTWInventory
extends TileTW
implements ISidedInventory {
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    protected int[] syncedSlots = new int[0];
    private NonNullList<ItemStack> syncedStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    protected String customName;
    private int[] faceSlots;
    protected IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    protected IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    protected IItemHandler handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    protected IItemHandler handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    protected IItemHandler handlerNorth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    protected IItemHandler handlerSouth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);

    public TileTWInventory(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.syncedStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.faceSlots = new int[size];
        for (int a = 0; a < size; ++a) {
            this.faceSlots[a] = a;
        }
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack getSyncedStackInSlot(int index) {
        return (ItemStack)this.syncedStacks.get(index);
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.getItems().get(index);
    }

    private boolean isSyncedSlot(int slot) {
        for (int num : this.syncedSlots) {
            if (num != slot) continue;
            return true;
        }
        return false;
    }

    protected void syncSlots(@Nullable EntityPlayerMP player) {
        if (this.syncedSlots.length > 0) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i).func_190926_b() || !this.isSyncedSlot(i)) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                this.func_70301_a(i).func_77955_b(compound);
                nbttaglist.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("ItemsSynced", (NBTBase)nbttaglist);
            this.sendMessageToClient(nbt, player);
        }
    }

    @Override
    public void syncTile(boolean rerender) {
        super.syncTile(rerender);
        this.syncSlots(null);
    }

    @Override
    public void messageFromClient(NBTTagCompound nbt, EntityPlayerMP player) {
        super.messageFromClient(nbt, player);
        if (nbt.func_74764_b("requestSync")) {
            this.syncSlots(player);
        }
    }

    @Override
    public void messageFromServer(NBTTagCompound nbt) {
        super.messageFromServer(nbt);
        if (nbt.func_74764_b("ItemsSynced")) {
            this.syncedStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            NBTTagList nbttaglist = nbt.func_150295_c("ItemsSynced", 10);
            for (int index = 0; index < nbttaglist.func_74745_c(); ++index) {
                NBTTagCompound compound = nbttaglist.func_150305_b(index);
                byte slot = compound.func_74771_c("Slot");
                if (!this.isSyncedSlot(slot)) continue;
                this.syncedStacks.set((int)slot, (Object)new ItemStack(compound));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("CustomName")) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks);
        return compound;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
        if (!stack.func_190926_b() && this.isSyncedSlot(index)) {
            this.syncSlots(null);
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.getItems(), (int)index);
        if (this.isSyncedSlot(index)) {
            this.syncSlots(null);
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.getItems().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
        if (this.isSyncedSlot(index)) {
            this.syncSlots(null);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.thaumic_wonders";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.faceSlots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.syncSlots(null);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("requestSync", true);
            this.sendMessageToServer(nbt);
        }
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return (T)this.handlerTop;
                }
                case DOWN: {
                    return (T)this.handlerBottom;
                }
                case NORTH: {
                    return (T)this.handlerNorth;
                }
                case SOUTH: {
                    return (T)this.handlerSouth;
                }
                case WEST: {
                    return (T)this.handlerWest;
                }
                case EAST: {
                    return (T)this.handlerEast;
                }
            }
            ThaumicWonders.LOGGER.error("Unknown facing value {} in TileTWInventory.getCapability", (Object)facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

