/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.research.theorycraft;

import com.verdantartifice.thaumicwonders.common.research.theorycraft.AbstractResearchEngineCard;
import com.verdantartifice.thaumicwonders.common.tiles.devices.IResearchEngine;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileInspirationEngine;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import thaumcraft.api.research.theorycraft.ResearchTableData;

public class CardInducedInspiration
extends AbstractResearchEngineCard {
    private String category = null;
    private int amount;

    public NBTTagCompound serialize() {
        NBTTagCompound nbt = super.serialize();
        nbt.func_74778_a("cat", this.category);
        nbt.func_74768_a("amt", this.amount);
        return nbt;
    }

    public void deserialize(NBTTagCompound nbt) {
        super.deserialize(nbt);
        this.category = nbt.func_74779_i("cat");
        this.amount = nbt.func_74762_e("amt");
    }

    public String getResearchCategory() {
        return this.category;
    }

    @Override
    protected int getResearchAmount(Random rng) {
        return this.amount;
    }

    @Override
    protected Class<? extends IResearchEngine> getEngineTileClass() {
        return TileInspirationEngine.class;
    }

    @Override
    public boolean initialize(EntityPlayer player, ResearchTableData data) {
        if (!super.initialize(player, data)) {
            return false;
        }
        if (data.categoryTotals.size() < 1) {
            return false;
        }
        int highestValue = 0;
        String highestKey = "";
        for (String category : data.categoryTotals.keySet()) {
            int value = data.getTotal(category);
            if (value <= highestValue) continue;
            highestValue = value;
            highestKey = category;
        }
        this.category = highestKey;
        this.amount = 5 + highestValue / 3;
        return true;
    }

    public String getLocalizedName() {
        return new TextComponentTranslation("card.induced_inspiration.name", new Object[0]).func_150260_c();
    }

    public String getLocalizedText() {
        return new TextComponentTranslation("card.induced_inspiration.text", new Object[]{this.amount, TextFormatting.BOLD + new TextComponentTranslation("tc.research_category." + this.category, new Object[0]).func_150254_d() + TextFormatting.RESET}).func_150260_c();
    }
}

