/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.lib.utils.Utils;

public class PacketTileToClient
implements IMessage {
    private long pos;
    private NBTTagCompound nbt;

    public PacketTileToClient() {
    }

    public PacketTileToClient(BlockPos pos, NBTTagCompound compound) {
        this.pos = pos.func_177986_g();
        this.nbt = compound;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        this.nbt = Utils.readNBTTagCompoundFromBuffer((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
        Utils.writeNBTTagCompoundToBuffer((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    implements IMessageHandler<PacketTileToClient, IMessage> {
        public IMessage onMessage(PacketTileToClient message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handle(PacketTileToClient message, MessageContext ctx) {
            TileEntity tile;
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            BlockPos bp = BlockPos.func_177969_a((long)message.pos);
            if (world != null && bp != null && (tile = world.func_175625_s(bp)) != null && tile instanceof TileTW) {
                ((TileTW)tile).messageFromServer(message.nbt == null ? new NBTTagCompound() : message.nbt);
            }
        }
    }
}

