/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.fx.FXDispatcher;

public class PacketMeteorbFx
implements IMessage {
    protected BlockPos source;
    protected int color;

    public PacketMeteorbFx() {
        this.source = null;
        this.color = 0;
    }

    public PacketMeteorbFx(BlockPos source, int color) {
        this.source = source;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        this.source = BlockPos.func_177969_a((long)buf.readLong());
        this.color = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.source.func_177986_g());
        buf.writeInt(this.color);
    }

    public static class Handler
    implements IMessageHandler<PacketMeteorbFx, IMessage> {
        public IMessage onMessage(PacketMeteorbFx message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handle(PacketMeteorbFx message, MessageContext ctx) {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            BlockPos targetPos = new BlockPos(message.source.func_177958_n(), world.func_72940_L(), message.source.func_177952_p());
            Color color = new Color(message.color);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            FXDispatcher.INSTANCE.arcBolt((double)message.source.func_177958_n() + 0.5, (double)message.source.func_177956_o() + 0.5, (double)message.source.func_177952_p() + 0.5, (double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() - 0.5, (double)targetPos.func_177952_p() + 0.5, r, g, b, 0.6f);
        }
    }
}

