/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketMeteorbFx;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TileMeteorb;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.aspects.Aspect;

public class PacketMeteorbAction
implements IMessage {
    private int targetWeather;
    private BlockPos tilePos;

    public PacketMeteorbAction() {
        this.targetWeather = -1;
        this.tilePos = null;
    }

    public PacketMeteorbAction(int targetWeather, BlockPos tilePos) {
        this.targetWeather = targetWeather;
        this.tilePos = tilePos;
    }

    public void fromBytes(ByteBuf buf) {
        this.targetWeather = buf.readInt();
        this.tilePos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.targetWeather);
        buf.writeLong(this.tilePos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<PacketMeteorbAction, IMessage> {
        public IMessage onMessage(PacketMeteorbAction message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketMeteorbAction message, MessageContext ctx) {
            EntityPlayerMP entityPlayer = ctx.getServerHandler().field_147369_b;
            World world = entityPlayer.func_130014_f_();
            WorldInfo worldinfo = world.func_72912_H();
            TileEntity tileEntity = world.func_175625_s(message.tilePos);
            if (tileEntity != null && tileEntity instanceof TileMeteorb) {
                TileMeteorb tile = (TileMeteorb)tileEntity;
                int duration = (300 + world.field_73012_v.nextInt(600)) * 20;
                if (message.targetWeather == 0 && tile.doesContainerContainAmount(Aspect.AIR, 50)) {
                    tile.takeFromContainer(Aspect.AIR, 50);
                    worldinfo.func_176142_i(duration);
                    worldinfo.func_76080_g(0);
                    worldinfo.func_76090_f(0);
                    worldinfo.func_76084_b(false);
                    worldinfo.func_76069_a(false);
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketLocalizedMessage("event.meteorb.used"), world.field_73011_w.getDimension());
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketMeteorbFx(message.tilePos, Aspect.AIR.getColor()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)message.tilePos.func_177958_n(), (double)message.tilePos.func_177956_o(), (double)message.tilePos.func_177952_p(), 32.0));
                } else if (message.targetWeather == 1 && tile.doesContainerContainAmount(Aspect.WATER, 50)) {
                    tile.takeFromContainer(Aspect.WATER, 50);
                    worldinfo.func_176142_i(0);
                    worldinfo.func_76080_g(duration);
                    worldinfo.func_76090_f(duration);
                    worldinfo.func_76084_b(true);
                    worldinfo.func_76069_a(false);
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketLocalizedMessage("event.meteorb.used"), world.field_73011_w.getDimension());
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketMeteorbFx(message.tilePos, Aspect.WATER.getColor()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)message.tilePos.func_177958_n(), (double)message.tilePos.func_177956_o(), (double)message.tilePos.func_177952_p(), 32.0));
                } else if (message.targetWeather == 2 && tile.doesContainerContainAmount(Aspect.ENERGY, 50)) {
                    tile.takeFromContainer(Aspect.ENERGY, 50);
                    worldinfo.func_176142_i(0);
                    worldinfo.func_76080_g(duration);
                    worldinfo.func_76090_f(duration);
                    worldinfo.func_76084_b(true);
                    worldinfo.func_76069_a(true);
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketLocalizedMessage("event.meteorb.used"), world.field_73011_w.getDimension());
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketMeteorbFx(message.tilePos, Aspect.ENERGY.getColor()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)message.tilePos.func_177958_n(), (double)message.tilePos.func_177956_o(), (double)message.tilePos.func_177952_p(), 32.0));
                } else {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.meteorb.unfueled"), entityPlayer);
                }
            }
        }
    }
}

