/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.tools;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.api.items.ItemsTC;

public class ItemPrimalDestroyer
extends ItemSword
implements IWarpingGear {
    public static final int MAX_HUNGER = 600;
    public static Item.ToolMaterial toolMatVoidflame = EnumHelper.addToolMaterial((String)"VOIDFLAME", (int)4, (int)200, (float)8.0f, (float)8.0f, (int)20).setRepairItem(new ItemStack(ItemsTC.ingots, 1, 1));

    public ItemPrimalDestroyer() {
        super(toolMatVoidflame);
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
        this.setRegistryName("thaumicwonders", "primal_destroyer");
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
    }

    public int getWarp(ItemStack itemStack, EntityPlayer player) {
        return 3;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && entityIn != null && entityIn.field_70173_aa % 20 == 0 && entityIn instanceof EntityPlayer) {
            boolean equipped;
            EntityPlayer entityPlayer = (EntityPlayer)entityIn;
            if (stack.func_77951_h()) {
                stack.func_77972_a(-1, (EntityLivingBase)entityPlayer);
            }
            boolean inOffHand = itemSlot == 0 && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)entityPlayer.func_184592_cb());
            boolean held = isSelected || inOffHand;
            boolean onHotbar = itemSlot >= 0 && itemSlot <= 8;
            boolean bl = equipped = held || onHotbar;
            if (equipped) {
                int hunger = 0;
                if (stack.func_77942_o()) {
                    hunger = stack.func_77978_p().func_74762_e("hunger");
                }
                if (hunger >= 600) {
                    if (entityIn instanceof EntityPlayerMP) {
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.primal_destroyer.hunger_full"), (EntityPlayerMP)entityIn);
                    }
                    entityPlayer.func_70097_a(new DamageSource("primalDestroyerHunger"), 12.0f);
                    entityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60));
                    entityPlayer.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 120));
                    hunger = 0;
                    IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)entityPlayer);
                    if (!knowledge.isResearchKnown("f_thevoidhungers")) {
                        knowledge.addResearch("f_thevoidhungers");
                        knowledge.sync((EntityPlayerMP)entityPlayer);
                    }
                } else {
                    ++hunger;
                }
                stack.func_77983_a("hunger", (NBTBase)new NBTTagInt(hunger));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() == newStack.func_77973_b() && !slotChanged) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!(target.field_70170_p.field_72995_K || target instanceof EntityPlayer && attacker instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W())) {
            try {
                target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60));
                target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 120));
                target.func_70015_d(3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!target.field_70170_p.field_72995_K) {
            if (target.func_110143_aJ() <= 0.0f) {
                this.decreaseHunger(stack, 600);
            } else {
                this.decreaseHunger(stack, 120);
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    private void decreaseHunger(ItemStack stack, int delta) {
        int hunger = 0;
        if (stack.func_77942_o()) {
            hunger = stack.func_77978_p().func_74762_e("hunger");
        }
        hunger = Math.max(0, hunger - delta);
        stack.func_77983_a("hunger", (NBTBase)new NBTTagInt(hunger));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"enchantment.special.sapgreat", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"enchantment.special.voidflame", (Object[])new Object[0]));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

