/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.items.consumables;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.entities.EntityPrimalArrow;
import com.verdantartifice.thaumicwonders.common.items.base.IVariantItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemPrimalArrow
extends ItemArrow
implements IVariantItem {
    protected final String baseName;
    protected String[] variants;
    protected int[] variantsMeta;

    public ItemPrimalArrow() {
        this.baseName = "primal_arrow";
        this.setRegistryName("thaumicwonders", this.baseName);
        this.func_77655_b("thaumicwonders." + this.getRegistryName().func_110623_a());
        this.func_77637_a(ThaumicWonders.CREATIVE_TAB);
        this.variants = new String[]{"air", "earth", "fire", "water", "order", "entropy"};
        this.func_77627_a(true);
        this.variantsMeta = new int[this.variants.length];
        for (int index = 0; index < this.variants.length; ++index) {
            this.variantsMeta[index] = index;
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.func_77614_k() && stack.func_77960_j() < this.variants.length && this.variants[stack.func_77960_j()] != this.baseName) {
            return String.format(super.func_77658_a() + ".%s", this.variants[stack.func_77960_j()]);
        }
        return super.func_77667_c(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == ThaumicWonders.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            if (!this.func_77614_k()) {
                super.func_150895_a(tab, items);
            } else {
                for (int meta : this.variantsMeta) {
                    items.add((Object)new ItemStack((Item)this, 1, meta));
                }
            }
        }
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public String[] getVariantNames() {
        return this.variants;
    }

    @Override
    public int[] getVariantMeta() {
        return this.variantsMeta;
    }

    @Override
    public ModelResourceLocation getCustomModelResourceLocation(String variant) {
        if (this.baseName.equals(variant)) {
            return new ModelResourceLocation("thaumicwonders:" + this.baseName);
        }
        return new ModelResourceLocation("thaumicwonders:" + this.baseName, variant);
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        EntityPrimalArrow entity = new EntityPrimalArrow(worldIn, shooter);
        entity.setArrowType(stack.func_77960_j());
        return entity;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        int enchantLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow);
        if (enchantLevel <= 0) {
            return false;
        }
        return player.field_70170_p.field_73012_v.nextInt(3) == 0;
    }
}

