/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.entities;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TilePortalAnchor;
import com.verdantartifice.thaumicwonders.common.tiles.devices.TilePortalGenerator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.lib.SoundsTC;

public class EntityVoidPortal
extends Entity {
    private static final DataParameter<Integer> LINK_X = EntityDataManager.func_187226_a(EntityVoidPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LINK_Y = EntityDataManager.func_187226_a(EntityVoidPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LINK_Z = EntityDataManager.func_187226_a(EntityVoidPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LINK_DIM = EntityDataManager.func_187226_a(EntityVoidPortal.class, (DataSerializer)DataSerializers.field_187192_b);
    private int soundTime = 0;
    private int cooldownTicks = 0;

    public EntityVoidPortal(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 3.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LINK_X, (Object)0);
        this.field_70180_af.func_187214_a(LINK_Y, (Object)0);
        this.field_70180_af.func_187214_a(LINK_Z, (Object)0);
        this.field_70180_af.func_187214_a(LINK_DIM, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setLinkX(compound.func_74762_e("linkX"));
        this.setLinkY(compound.func_74762_e("linkY"));
        this.setLinkZ(compound.func_74762_e("linkZ"));
        this.setLinkDim(compound.func_74762_e("linkDim"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("linkX", this.getLinkX());
        compound.func_74768_a("linkY", this.getLinkY());
        compound.func_74768_a("linkZ", this.getLinkZ());
        compound.func_74768_a("linkDim", this.getLinkDim());
    }

    public int getLinkX() {
        return (Integer)this.field_70180_af.func_187225_a(LINK_X);
    }

    public int getLinkY() {
        return (Integer)this.field_70180_af.func_187225_a(LINK_Y);
    }

    public int getLinkZ() {
        return (Integer)this.field_70180_af.func_187225_a(LINK_Z);
    }

    public int getLinkDim() {
        return (Integer)this.field_70180_af.func_187225_a(LINK_DIM);
    }

    public void setLinkX(int linkX) {
        this.field_70180_af.func_187227_b(LINK_X, (Object)linkX);
    }

    public void setLinkY(int linkY) {
        this.field_70180_af.func_187227_b(LINK_Y, (Object)linkY);
    }

    public void setLinkZ(int linkZ) {
        this.field_70180_af.func_187227_b(LINK_Z, (Object)linkZ);
    }

    public void setLinkDim(int linkDim) {
        this.field_70180_af.func_187227_b(LINK_DIM, (Object)linkDim);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public float getGeneratorStability() {
        TileEntity generatorTile = this.field_70170_p.func_175625_s(this.func_180425_c().func_177977_b());
        if (generatorTile != null && generatorTile instanceof TilePortalGenerator) {
            return ((TilePortalGenerator)generatorTile).getStability();
        }
        return 0.0f;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && this.cooldownTicks <= 0) {
            int max;
            this.cooldownTicks = 3;
            int dx = 0;
            int dz = 0;
            float stability = this.getGeneratorStability();
            if (stability < -25.0f) {
                max = (int)(12.5f + (0.5f * Math.abs(stability) - 12.5f) * (0.5f * Math.abs(stability) - 12.5f));
                if (max > 0) {
                    dx = this.field_70170_p.field_73012_v.nextInt(max) - this.field_70170_p.field_73012_v.nextInt(max);
                    dz = this.field_70170_p.field_73012_v.nextInt(max) - this.field_70170_p.field_73012_v.nextInt(max);
                }
            } else if (stability < 0.0f && (max = (int)(0.5f * Math.abs(stability))) > 0) {
                dx = this.field_70170_p.field_73012_v.nextInt(max) - this.field_70170_p.field_73012_v.nextInt(max);
                dz = this.field_70170_p.field_73012_v.nextInt(max) - this.field_70170_p.field_73012_v.nextInt(max);
            }
            BlockPos linkPos = new BlockPos(this.getLinkX(), this.getLinkY(), this.getLinkZ());
            BlockPos targetPos = linkPos.func_177982_a(dx, 0, dz);
            World sourceWorld = this.field_70170_p;
            WorldServer targetWorld = DimensionManager.getWorld((int)this.getLinkDim());
            if (targetWorld == null) {
                DimensionManager.initDimension((int)this.getLinkDim());
                targetWorld = DimensionManager.getWorld((int)this.getLinkDim());
            }
            if (targetWorld != null) {
                TileEntity tile = targetWorld.func_175625_s(linkPos);
                if (tile != null && tile instanceof TilePortalAnchor) {
                    AuraHelper.polluteAura((World)sourceWorld, (BlockPos)this.func_180425_c(), (float)5.0f, (boolean)true);
                    if (player.field_70170_p.field_73011_w.getDimension() != this.getLinkDim()) {
                        player.changeDimension(this.getLinkDim(), new ITeleporter(){

                            public void placeEntity(World world, Entity entity, float yaw) {
                            }
                        });
                    }
                    player.func_70634_a((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 1.0, (double)targetPos.func_177952_p() + 0.5);
                    if (player.field_70170_p.field_73011_w.getDimension() == this.getLinkDim()) {
                        player.field_70170_p.func_184133_a(null, targetPos.func_177984_a(), SoundEvents.field_187812_eh, SoundCategory.NEUTRAL, 0.25f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                    AuraHelper.polluteAura((World)targetWorld, (BlockPos)targetPos.func_177984_a(), (float)5.0f, (boolean)true);
                } else if (player instanceof EntityPlayerMP) {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.void_portal.no_anchor"), (EntityPlayerMP)player);
                }
            } else {
                if (player instanceof EntityPlayerMP) {
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketLocalizedMessage("event.void_portal.no_world"), (EntityPlayerMP)player);
                }
                ThaumicWonders.LOGGER.error("Target dimension {} not found!", (Object)this.getLinkDim());
            }
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70128_L && this.field_70146_Z.nextInt(1000) < this.soundTime++) {
            this.soundTime = -540;
            this.func_184185_a(SoundsTC.monolith, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.cooldownTicks = Math.max(0, --this.cooldownTicks);
    }
}

