/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.essentia;

import com.verdantartifice.thaumicwonders.common.blocks.base.BlockTileTW;
import com.verdantartifice.thaumicwonders.common.blocks.essentia.ItemBlockCreativeEssentiaJar;
import com.verdantartifice.thaumicwonders.common.tiles.essentia.TileCreativeEssentiaJar;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.ILabelable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.lib.SoundsTC;

public class BlockCreativeEssentiaJar
extends BlockTileTW<TileCreativeEssentiaJar>
implements ILabelable {
    private static final int CAPACITY = 250;

    public BlockCreativeEssentiaJar() {
        super(Material.field_151592_s, TileCreativeEssentiaJar.class, "creative_essentia_jar");
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundsTC.JAR);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public SoundType func_185467_w() {
        return SoundsTC.JAR;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileCreativeEssentiaJar) {
            this.spawnFilledJar(worldIn, pos, state, (TileCreativeEssentiaJar)tileEntity);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileCreativeEssentiaJar) {
            this.spawnFilledJar(worldIn, pos, state, (TileCreativeEssentiaJar)te);
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    private void spawnFilledJar(World world, BlockPos pos, IBlockState state, TileCreativeEssentiaJar te) {
        ItemStack drop = new ItemStack((Block)this, 1, this.func_176201_c(state));
        if (te.amount > 0) {
            ((ItemBlockCreativeEssentiaJar)drop.func_77973_b()).setAspects(drop, new AspectList().add(te.aspect, te.amount));
        }
        if (te.aspectFilter != null) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            drop.func_77978_p().func_74778_a("AspectFilter", te.aspectFilter.getTag());
        }
        if (te.blocked) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(ItemsTC.jarBrace));
        }
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileCreativeEssentiaJar) {
            switch (l) {
                case 0: {
                    ((TileCreativeEssentiaJar)tile).facing = 2;
                    break;
                }
                case 1: {
                    ((TileCreativeEssentiaJar)tile).facing = 5;
                    break;
                }
                case 2: {
                    ((TileCreativeEssentiaJar)tile).facing = 3;
                    break;
                }
                case 3: {
                    ((TileCreativeEssentiaJar)tile).facing = 4;
                }
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileCreativeEssentiaJar) {
            TileCreativeEssentiaJar tileEntity = (TileCreativeEssentiaJar)te;
            if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() == ItemsTC.phial) {
                ItemPhial itemPhial = (ItemPhial)ItemsTC.phial;
                if (playerIn.func_184586_b(hand).func_77952_i() == 0 && tileEntity.amount >= 10) {
                    if (!worldIn.field_72995_K && tileEntity.aspect != null && tileEntity.takeFromContainer(tileEntity.aspect, 10)) {
                        playerIn.func_184586_b(hand).func_190918_g(1);
                        ItemStack newPhialStack = new ItemStack((Item)itemPhial, 1, 1);
                        itemPhial.setAspects(newPhialStack, new AspectList().add(tileEntity.aspect, 10));
                        if (!playerIn.field_71071_by.func_70441_a(newPhialStack)) {
                            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), newPhialStack));
                        }
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.PLAYERS, 0.5f, 1.0f);
                        playerIn.field_71069_bz.func_75142_b();
                    }
                } else {
                    AspectList phialAspects = itemPhial.getAspects(playerIn.func_184586_b(hand));
                    if (phialAspects != null && phialAspects.size() == 1) {
                        Aspect aspect = phialAspects.getAspects()[0];
                        if (!worldIn.field_72995_K && playerIn.func_184586_b(hand).func_77952_i() != 0 && tileEntity.amount <= 240 && tileEntity.doesContainerAccept(aspect) && tileEntity.addToContainer(aspect, 10) == 0) {
                            worldIn.markAndNotifyBlock(pos, worldIn.func_175726_f(pos), state, state, 3);
                            tileEntity.syncTile(true);
                            playerIn.func_184586_b(hand).func_190918_g(1);
                            ItemStack newPhialStack = new ItemStack((Item)itemPhial, 1, 0);
                            if (!playerIn.field_71071_by.func_70441_a(newPhialStack)) {
                                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), newPhialStack));
                            }
                            worldIn.func_184133_a(null, pos, SoundEvents.field_191241_J, SoundCategory.PLAYERS, 0.5f, 1.0f);
                            playerIn.field_71069_bz.func_75142_b();
                        }
                    }
                }
            } else if (!tileEntity.blocked && playerIn.func_184586_b(hand).func_77973_b() == ItemsTC.jarBrace) {
                tileEntity.blocked = true;
                playerIn.func_184586_b(hand).func_190918_g(1);
                if (worldIn.field_72995_K) {
                    worldIn.func_184133_a(null, pos, SoundsTC.key, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    tileEntity.func_70296_d();
                }
            } else if (playerIn.func_70093_af() && tileEntity.aspectFilter != null && facing.ordinal() == tileEntity.facing) {
                tileEntity.aspectFilter = null;
                if (worldIn.field_72995_K) {
                    worldIn.func_184133_a(null, pos, SoundsTC.page, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)((float)pos.func_177958_n() + 0.5f + (float)facing.func_82601_c() / 3.0f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f + (float)facing.func_82599_e() / 3.0f), new ItemStack(ItemsTC.label)));
                }
            } else if (playerIn.func_70093_af() && playerIn.func_184586_b(hand).func_190926_b()) {
                if (tileEntity.aspectFilter == null) {
                    tileEntity.aspect = null;
                }
                if (worldIn.field_72995_K) {
                    worldIn.func_184133_a(null, pos, SoundsTC.jar, SoundCategory.BLOCKS, 0.4f, 1.0f);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.5f, 1.0f + (2.0f * worldIn.field_73012_v.nextFloat() - 1.0f) * 0.3f);
                } else {
                    AuraHelper.polluteAura((World)worldIn, (BlockPos)pos, (float)tileEntity.amount, (boolean)true);
                }
                tileEntity.amount = 0;
                tileEntity.func_70296_d();
            }
        }
        return true;
    }

    public boolean applyLabel(EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack labelStack) {
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te != null && te instanceof TileCreativeEssentiaJar) {
            TileCreativeEssentiaJar tileEntity = (TileCreativeEssentiaJar)te;
            if (labelStack.func_77973_b() instanceof IEssentiaContainerItem) {
                IEssentiaContainerItem labelItem = (IEssentiaContainerItem)labelStack.func_77973_b();
                if (tileEntity.aspectFilter == null) {
                    if (tileEntity.amount == 0 && labelItem.getAspects(labelStack) == null) {
                        return false;
                    }
                    if (tileEntity.amount == 0 && labelItem.getAspects(labelStack) != null) {
                        tileEntity.aspect = labelItem.getAspects(labelStack).getAspects()[0];
                    }
                    this.func_180633_a(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), (EntityLivingBase)player, null);
                    tileEntity.aspectFilter = tileEntity.aspect;
                    player.field_70170_p.markAndNotifyBlock(pos, player.field_70170_p.func_175726_f(pos), player.field_70170_p.func_180495_p(pos), player.field_70170_p.func_180495_p(pos), 3);
                    tileEntity.func_70296_d();
                    player.field_70170_p.func_184133_a(null, pos, SoundsTC.jar, SoundCategory.BLOCKS, 0.4f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileCreativeEssentiaJar) {
            TileCreativeEssentiaJar tileEntity = (TileCreativeEssentiaJar)te;
            float ratio = (float)tileEntity.amount / 250.0f;
            return MathHelper.func_76141_d((float)(ratio * 14.0f)) + (tileEntity.amount > 0 ? 1 : 0);
        }
        return super.func_180641_l(blockState, worldIn, pos);
    }
}

