/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.blocks.devices;

import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockFluxCapacitor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockFluxCapacitor
extends ItemBlock {
    public ItemBlockFluxCapacitor(Block block) {
        super(block);
        this.func_185043_a(new ResourceLocation("thaumicwonders", "flux"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                int charge;
                int n = charge = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("charge") : 0;
                if (charge <= 0) {
                    return 0.0f;
                }
                if (charge <= 3) {
                    return 1.0f;
                }
                if (charge <= 6) {
                    return 2.0f;
                }
                if (charge <= 9) {
                    return 3.0f;
                }
                return 4.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int charge = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("charge") : 0;
        tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tile.thaumicwonders.flux_capacitor.tooltip.flux", (Object[])new Object[]{charge}));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean success = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (success && !world.field_72995_K) {
            int charge = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("charge") : 0;
            world.func_175656_a(pos, newState.func_177226_a((IProperty)BlockFluxCapacitor.CHARGE, (Comparable)Integer.valueOf(charge)));
        }
        return success;
    }
}

