/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.LibNine;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class WorldBlockPos {
    private final BlockPos pos;
    private final World world;

    public WorldBlockPos(World world, int x, int y, int z) {
        this.pos = new BlockPos(x, y, z).func_185334_h();
        this.world = world;
    }

    public WorldBlockPos(int dim, int x, int y, int z) {
        this(LibNine.PROXY.getDimensionWorldStrict(dim), x, y, z);
    }

    public WorldBlockPos(World world, BlockPos pos) {
        this(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public WorldBlockPos(int dim, BlockPos pos) {
        this(dim, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public World getWorld() {
        return this.world;
    }

    public int getDimId() {
        return this.world.field_73011_w.getDimension();
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.pos);
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.pos);
    }

    public Block getBlock() {
        return this.getBlockState().func_177230_c();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public WorldBlockPos offset(Vec3i vec) {
        return new WorldBlockPos(this.world, this.pos.func_177971_a(vec));
    }

    public WorldBlockPos offset(EnumFacing dir) {
        return new WorldBlockPos(this.world, this.pos.func_177972_a(dir));
    }

    public boolean equals(Object o) {
        return o instanceof WorldBlockPos && this.pos.equals((Object)((WorldBlockPos)o).pos) && this.getDimId() == ((WorldBlockPos)o).getDimId();
    }

    public int hashCode() {
        return this.world.hashCode() ^ this.pos.hashCode();
    }

    public String toString() {
        return String.format("(%d, %d, %d) @ %s", this.getX(), this.getY(), this.getZ(), this.world.func_72827_u());
    }
}

