/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class MirrorUtils {
    @Nullable
    private static Field fField_modifiers = null;

    public static void writeModifiers(Field field, int modifiers) {
        if (fField_modifiers == null) {
            try {
                fField_modifiers = Field.class.getDeclaredField("modifiers");
                fField_modifiers.setAccessible(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to reflect field modifiers!", e);
            }
        }
        try {
            fField_modifiers.setInt(field, modifiers);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to write field modifieres!", e);
        }
    }

    public static <T> List<Class<? super T>> getHierarchy(Class<T> clazz) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Class<T> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
        }
        return result;
    }

    public static <T> IMethod<T> reflectMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            method.setAccessible(true);
            return new IMethod.Impl(method);
        }
        catch (NoSuchMethodException e) {
            throw new MirrorException(String.format("Could not reflect method: %s/%s %s", clazz.getName(), name, Arrays.toString(args)), e);
        }
    }

    public static <T> IField<T> reflectField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return new IField.Impl(field);
        }
        catch (NoSuchFieldException e) {
            throw new MirrorException(String.format("Could not reflect field: %s/%s", clazz.getName(), name), e);
        }
    }

    public static class MirrorException
    extends RuntimeException {
        MirrorException(String reason, Exception cause) {
            super(reason, cause);
        }
    }

    public static interface IField<T> {
        default public void set(@Nullable Object target, T value) {
            try {
                Field field = this.unwrap();
                int modifiers = field.getModifiers();
                if ((modifiers & 0x10) != 0) {
                    MirrorUtils.writeModifiers(field, modifiers & 0xFFFFFFEF);
                }
                field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new MirrorException("Could not mutate field: " + this.unwrap(), e);
            }
        }

        default public T get(@Nullable Object target) {
            try {
                return (T)this.unwrap().get(target);
            }
            catch (IllegalAccessException e) {
                throw new MirrorException("Could not read field: " + this.unwrap(), e);
            }
        }

        public Field unwrap();

        public static class Impl<T>
        implements IField<T> {
            private final Field field;

            Impl(Field field) {
                this.field = field;
            }

            @Override
            public Field unwrap() {
                return this.field;
            }
        }
    }

    public static interface IMethod<T> {
        default public T invoke(@Nullable Object target, Object ... args) {
            try {
                return (T)this.unwrap().invoke(target, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new MirrorException("Could not invoke method: " + this.unwrap(), e);
            }
        }

        public Method unwrap();

        public static class Impl<T>
        implements IMethod<T> {
            private final Method method;

            Impl(Method method) {
                this.method = method;
            }

            @Override
            public Method unwrap() {
                return this.method;
            }
        }
    }
}

