/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.multiblock;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockCore;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import io.github.phantamanta44.libnine.util.world.structmatcher.IStructureMatcher;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;

public class MultiBlockType<T extends IMultiBlockUnit<T>> {
    private final ResourceLocation id;
    private final int maxSearchDist;
    private final Class<T> componentType;
    @Nullable
    private IStructureMatcher structureMatcher;

    public MultiBlockType(ResourceLocation id, int maxSearchDist, Class<T> componentType) {
        this.id = id;
        this.maxSearchDist = maxSearchDist;
        this.componentType = componentType;
    }

    @Nullable
    public T checkComponent(@Nullable Object obj) {
        return (T)(this.componentType.isInstance(obj) ? (IMultiBlockUnit)obj : null);
    }

    public int getMaxSearchDist() {
        return this.maxSearchDist;
    }

    public void setStructureMatcher(IStructureMatcher structureMatcher) {
        this.structureMatcher = structureMatcher;
    }

    public boolean checkStructure(MultiBlockCore<T> core) {
        if (this.structureMatcher == null) {
            return true;
        }
        WorldBlockPos basePos = core.getUnit().getWorldPos();
        return this.structureMatcher.testStructure(basePos, StreamSupport.stream(core.spliterator(), false).map(c -> c.getUnit().getWorldPos().getPos().func_177973_b((Vec3i)basePos.getPos())).collect(Collectors.toList()));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MultiBlockType && this.id.equals((Object)((MultiBlockType)obj).id);
    }

    public String toString() {
        return this.id.toString();
    }
}

