/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component.impl;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.render.TextureRegion;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;

public class GuiComponentButton
extends GuiComponent {
    @Nullable
    private final String tooltipKey;
    private final TextureRegion texNormal;
    private final TextureRegion texHovered;
    private final TextureRegion texDisabled;
    private final Runnable callback;
    private boolean disabled = false;

    public GuiComponentButton(int x, int y, int width, int height, @Nullable String tooltipKey, TextureRegion texNormal, TextureRegion texHovered, TextureRegion texDisabled, Runnable callback) {
        super(x, y, width, height);
        this.tooltipKey = tooltipKey;
        this.texNormal = texNormal;
        this.texHovered = texHovered;
        this.texDisabled = texDisabled;
        this.callback = callback;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        (this.disabled ? this.texDisabled : (mouseOver ? this.texHovered : this.texNormal)).draw(this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean onClick(int mX, int mY, int button, boolean mouseOver) {
        if (mouseOver && !this.disabled && button == 0) {
            this.callback.run();
            GuiComponentButton.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void renderTooltip(float partialTicks, int mX, int mY) {
        if (this.tooltipKey != null) {
            this.drawTooltip(I18n.func_135052_a((String)this.tooltipKey, (Object[])new Object[0]), mX, mY);
        }
    }
}

