/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui;

import io.github.phantamanta44.libnine.client.gui.IScreenDrawable;
import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.client.gui.component.GuiComponentManager;
import io.github.phantamanta44.libnine.gui.L9Container;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class L9GuiContainer
extends GuiContainer
implements IScreenDrawable {
    protected final int sizeX;
    protected final int sizeY;
    @Nullable
    private final ResourceLocation bg;
    private final GuiComponentManager components;
    private int posX;
    private int posY;
    private float partialTicks;

    public L9GuiContainer(L9Container container, @Nullable ResourceLocation bg, int sizeX, int sizeY) {
        super((Container)container);
        this.bg = bg;
        this.sizeX = this.field_146999_f = sizeX;
        this.sizeY = this.field_147000_g = sizeY;
        this.components = new GuiComponentManager((GuiScreen)this);
    }

    public L9GuiContainer(L9Container container, @Nullable ResourceLocation bg) {
        this(container, bg, 176, 166);
    }

    public L9GuiContainer(L9Container container) {
        this(container, null);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.posX = (this.field_146294_l - this.sizeX) / 2;
        this.posY = (this.field_146295_m - this.sizeY) / 2;
    }

    public int getOffsetX() {
        return this.posX;
    }

    public int getOffsetY() {
        return this.posY;
    }

    @Override
    public void addComponent(GuiComponent comp) {
        this.components.register(comp);
    }

    public void func_73863_a(int mX, int mY, float partialTicks) {
        super.func_73863_a(mX, mY, partialTicks);
        this.func_191948_b(mX, mY);
    }

    protected void func_146976_a(float partialTicks, int mX, int mY) {
        this.partialTicks = partialTicks;
        this.drawBackground(partialTicks, mX - this.posX, mY - this.posY);
    }

    protected void func_146979_b(int mX, int mY) {
        this.drawForeground(this.partialTicks, mX - this.posX, mY - this.posY);
        this.components.draw(this.partialTicks, mX - this.posX, mY - this.posY);
        this.drawOverlay(this.partialTicks, mX - this.posX, mY - this.posY);
    }

    @Override
    public void drawBackground(float partialTicks, int mX, int mY) {
        this.func_146276_q_();
        if (this.bg != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(this.bg);
            this.func_73729_b(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
        }
    }

    @Override
    public void drawForeground(float partialTicks, int mX, int mY) {
        this.drawPlayerInventoryName();
    }

    @Override
    public void drawOverlay(float partialTicks, int mX, int mY) {
    }

    protected void drawContainerName(String name) {
        this.field_146289_q.func_78276_b(name, 8, 6, 0x404040);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void drawPlayerInventoryName() {
        this.field_146289_q.func_78276_b(I18n.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void drawString(String string, int x, int y, int colour, boolean shadow) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(string, (float)x, (float)y, colour, shadow);
    }

    protected void drawString(String string, int x, int y, int colour) {
        this.drawString(string, x, y, colour, false);
    }

    protected void drawTooltip(String string, int x, int y) {
        this.func_146279_a(string, x, y);
        RenderHelper.func_74520_c();
    }

    protected void drawTooltip(List<String> lines, int x, int y) {
        this.func_146283_a(lines, x, y);
        RenderHelper.func_74520_c();
    }

    protected void func_73864_a(int mX, int mY, int button) throws IOException {
        if (this.components.handleMouseClick(mX - this.posX, mY - this.posY, button)) {
            super.func_73864_a(mX, mY, button);
        }
    }

    protected void func_146273_a(int mX, int mY, int button, long dragTime) {
        if (this.components.handleMouseDrag(mX - this.posX, mY - this.posY, button, dragTime)) {
            super.func_146273_a(mX, mY, button, dragTime);
        }
    }

    protected void func_73869_a(char typed, int keyCode) throws IOException {
        if (this.components.handleKeyTyped(typed, keyCode)) {
            super.func_73869_a(typed, keyCode);
        }
    }
}

