/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal.thunder;

import com.zeitheron.hammercore.client.particle.def.thunder.ThunderBoltParticle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Thunder {
    public final long seed;
    public final int age;
    public final float angleMult;

    public Thunder(long seed, int age, float multiplier) {
        this.seed = seed;
        this.age = age;
        this.angleMult = multiplier;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74772_a("Seed", this.seed);
        c.func_74768_a("Age", this.age);
        c.func_74776_a("Mult", this.angleMult);
        return c;
    }

    public static Thunder deserializeNBT(NBTTagCompound nbt) {
        return new Thunder(nbt.func_74763_f("Seed"), nbt.func_74762_e("Age"), nbt.func_74760_g("Mult"));
    }

    public static class Fractal {
        public static final Fractal DEFAULT_FRACTAL = new Fractal();
        public final int splits;
        public final float baseAngle;

        public Fractal(int splits, float angle) {
            this.splits = splits;
            this.baseAngle = angle;
        }

        public Fractal() {
            this(2, 45.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void apply(ThunderBoltParticle thunder) {
            thunder.defaultFractal(this.splits, this.baseAngle);
        }
    }

    public static final class Layer {
        private static long counter = 0L;
        public final int blendFunc;
        public final int color;
        public final boolean active;

        public Layer(int func, int color, boolean active) {
            ++counter;
            this.blendFunc = func;
            this.color = color;
            this.active = active;
        }

        public Layer(boolean active) {
            this(771, counter % 2L == 1L ? 0xFF00FF : 0, active);
        }

        public Layer() {
            this(true);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound c = new NBTTagCompound();
            c.func_74757_a("Active", this.active);
            if (this.active) {
                c.func_74768_a("BFunc", this.blendFunc);
                c.func_74768_a("RGB", this.color);
            }
            return c;
        }

        public static Layer deserializeNBT(NBTTagCompound nbt) {
            return new Layer(nbt.func_74762_e("BFunc"), nbt.func_74762_e("RGB"), nbt.func_74767_n("Active"));
        }
    }
}

