/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.variables;

import com.zeitheron.hammercore.internal.variables.IVariable;
import com.zeitheron.hammercore.utils.base.SideLocal;
import net.minecraft.util.ResourceLocation;

public abstract class BaseVariable<T>
implements IVariable<T> {
    protected final ResourceLocation id;
    protected final SideLocal<T> storage = this.createStorage();
    protected boolean isDirty;

    public BaseVariable(ResourceLocation id) {
        this.id = id;
    }

    protected abstract boolean hasChanged(T var1, T var2);

    protected SideLocal<T> createStorage() {
        return SideLocal.createEmpty();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public T get() {
        return this.storage.get();
    }

    @Override
    public void set(T t) {
        T value = this.get();
        if (this.hasChanged(value, t)) {
            this.storage.set(t);
            this.isDirty = true;
        }
    }

    @Override
    public boolean hasChanged() {
        return this.isDirty;
    }

    @Override
    public void setNotChanged() {
        this.isDirty = false;
    }
}

