/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal.items;

import com.zeitheron.hammercore.command.CommandTimeToTicks;
import com.zeitheron.hammercore.internal.capabilities.ItemCapabilityProvider;
import com.zeitheron.hammercore.utils.energy.IPowerContainerItem;
import com.zeitheron.hammercore.utils.energy.IPowerStorage;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFEBase
extends Item
implements IPowerContainerItem {
    protected int maxFE;
    protected int maxExtract;
    protected int maxReceive;
    protected int durabilityRGB = 0xFF2222;

    public ItemFEBase(int maxFE) {
        this.maxFE = maxFE;
        this.func_77625_d(1);
        this.func_77656_e(255);
    }

    public int getMaxFE() {
        return this.maxFE;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        float damage = Math.max(0.0f, (float)(stack.func_77958_k() - stack.func_77952_i()) / (float)stack.func_77958_k());
        int target = (int)(damage * 255.0f);
        target = target << 16 | target << 8 | target;
        return MathHelper.func_180188_d((int)target, (int)this.durabilityRGB);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack stack = new ItemStack((Item)this);
        subItems.add((Object)stack);
        this.setFE(stack, 0);
        stack = new ItemStack((Item)this);
        subItems.add((Object)stack);
        this.setFE(stack, this.maxFE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int fe = this.getEnergyStored(stack);
        tooltip.add(I18n.func_135052_a((String)"info.hammercore:energy_stored", (Object[])new Object[0]) + ": " + CommandTimeToTicks.fancyFormat(fe));
    }

    public ItemCapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        ItemCapabilityProvider provider = new ItemCapabilityProvider();
        provider.putCapability(CapabilityEnergy.ENERGY, new ItemEnergyHolder(stack));
        return provider;
    }

    public void setFE(ItemStack stack, int fe) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("EnergyStored", fe);
        stack.func_77964_b(com.zeitheron.hammercore.utils.math.MathHelper.clip((int)(256.0 - (double)fe / (double)this.maxFE * 255.0), 0, this.func_77612_l()));
    }

    @Override
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        if (this.maxReceive <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored(stack);
        int energyReceived = Math.min(this.maxFE - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setFE(stack, energy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        if (this.maxExtract <= 0) {
            return 0;
        }
        int energy = this.getEnergyStored(stack);
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setFE(stack, energy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("EnergyStored");
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return this.maxFE;
    }

    public class ItemEnergyHolder
    implements IEnergyStorage,
    IPowerStorage {
        public final ItemStack stack;

        public ItemEnergyHolder(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ItemFEBase.this.receiveEnergy(this.stack, maxReceive, simulate);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return ItemFEBase.this.extractEnergy(this.stack, maxExtract, simulate);
        }

        @Override
        public int getEnergyStored() {
            return ItemFEBase.this.getEnergyStored(this.stack);
        }

        @Override
        public int getMaxEnergyStored() {
            return ItemFEBase.this.maxFE;
        }

        public boolean canExtract() {
            return ItemFEBase.this.maxExtract > 0;
        }

        public boolean canReceive() {
            return ItemFEBase.this.maxReceive > 0;
        }
    }
}

