/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryCategory;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.IConfigEntry;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ReaderHelper;

public final class ConfigSerializerCategory
extends ConfigEntrySerializer<ConfigEntryCategory> {
    public ConfigSerializerCategory() {
        super("C");
    }

    @Override
    public void write(Configuration config, BufferedWriter writer, ConfigEntryCategory entry, int indents) throws IOException {
        if (entry.getDescription() != null) {
            this.writeComment(writer, entry.getDescription() + "\n", indents);
        }
        this.writeIndents(writer, indents);
        writer.write("+" + this.type + ":" + entry.getName() + "={\n");
        for (IConfigEntry e : entry.entries.values().stream().sorted((a, b) -> a.getName().compareTo(b.getName())).collect(Collectors.toList())) {
            ConfigEntrySerializer<?> s = e.getSerializer();
            s.write(config, writer, e, indents + 2);
        }
        this.writeIndents(writer, indents);
        writer.write("}\n\n");
    }

    @Override
    public ConfigEntryCategory read(Configuration config, ReaderHelper reader, int indents) throws IOException {
        ConfigEntryCategory cat = new ConfigEntryCategory(config);
        reader.until('+', true);
        if (reader.eat(this.type, true) && reader.eat(':', true)) {
            String name = reader.until('=', true);
            if (reader.eat('{', true)) {
                cat.name = name;
                char[] ics = new char[indents + 2];
                Arrays.fill(ics, ' ');
                ics[0] = 10;
                ics[indents + 1] = 125;
                String sub = reader.getRest();
                sub = sub.substring(0, sub.indexOf("\n}"));
                int il = sub.length();
                sub = sub.replaceAll("\n  ", "\n");
                ReaderHelper child = new ReaderHelper(sub);
                while (true) {
                    Object e;
                    int pos = child.push();
                    child.until('+', true);
                    if (child.currentLine().contains("#")) {
                        child.until('\n', true);
                        continue;
                    }
                    String c = child.until(':', true);
                    ConfigEntrySerializer<?> s = Configuration.getSerializers().get(c);
                    child.pop(pos);
                    if (s == null || (e = s.read(config, child, indents + 2)) == null || e.getName() == null) break;
                    cat.entries.put(e.getName(), (IConfigEntry)e);
                }
                reader.pop(reader.push() + il);
            }
        }
        return cat;
    }
}

