/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.proxy;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.solarflux.SolarFlux;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.solarflux.client.SolarFluxResourcePack;
import tk.zeitheron.solarflux.client.SolarPanelBakedModel;
import tk.zeitheron.solarflux.gui.ContainerBaseSolar;
import tk.zeitheron.solarflux.init.SolarsSF;
import tk.zeitheron.solarflux.net.NetworkSF;
import tk.zeitheron.solarflux.proxy.ISFProxy;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
implements ISFProxy {
    private List<Item> render = new ArrayList<Item>();
    public static final SolarFluxResourcePack builtin = new SolarFluxResourcePack();
    public boolean renderedWorld;

    @Override
    public void construct() {
    }

    @Override
    public void onPanelRegistered(SolarInfo info) {
        builtin.addPanel(info);
    }

    @Override
    public void preInit() {
        try {
            ClientProxy.builtin.domains.addAll(SolarFluxAPI.resourceDomains);
            Field resourcePackList = FMLClientHandler.class.getDeclaredField("resourcePackList");
            resourcePackList.setAccessible(true);
            List rps = (List)resourcePackList.get(FMLClientHandler.instance());
            rps.add(3, builtin);
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)builtin);
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110545_a((IResourcePack)builtin);
            SolarFlux.LOG.info("Injected custom resource pack.");
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.render.forEach(this::registerRender);
        this.render.clear();
        this.render = null;
    }

    @Override
    public void postInit() {
        SolarFluxResourcePack.injectSolarPanelLanguages();
    }

    @Override
    public void render(Item item) {
        this.render.add(item);
    }

    @Override
    public void updateWindow(int window, int key, long val) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            EntityPlayerSP pl = Minecraft.func_71410_x().field_71439_g;
            if (pl != null && pl.field_71070_bA != null && pl.field_71070_bA.field_75152_c == window && pl.field_71070_bA instanceof ContainerBaseSolar) {
                ((ContainerBaseSolar)pl.field_71070_bA).updateProgressBar2(key, val);
            }
        });
    }

    @SubscribeEvent
    public void guiInit(GuiScreenEvent.InitGuiEvent.Post e) {
        Calendar c;
        if (e.getGui() instanceof GuiMainMenu && (c = Calendar.getInstance()).get(2) == 10 && c.get(5) == 10) {
            GuiMainMenu gmm = (GuiMainMenu)e.getGui();
            gmm.field_73975_c = "Happy birthday, Zeitheron!";
        }
    }

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre e) {
        SolarsSF.listPanels().stream().map(SolarInfo::getBlock).forEach(spb -> {
            e.getMap().func_174942_a(new ResourceLocation(spb.getRegistryName().func_110624_b(), "blocks/" + spb.getRegistryName().func_110623_a() + "_base"));
            e.getMap().func_174942_a(new ResourceLocation(spb.getRegistryName().func_110624_b(), "blocks/" + spb.getRegistryName().func_110623_a() + "_top"));
        });
    }

    @SubscribeEvent
    public void modelBake(ModelBakeEvent e) {
        SolarsSF.listPanels().stream().map(SolarInfo::getBlock).forEach(spb -> e.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(spb.getRegistryName(), ""), (Object)new SolarPanelBakedModel((BlockBaseSolar)((Object)spb))));
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent e) {
        if (!this.renderedWorld) {
            this.renderedWorld = true;
            NetworkSF.INSTANCE.requestConfigs();
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71441_e == null && this.renderedWorld) {
            this.renderedWorld = false;
            SolarFlux.LOG.info("Resetting configs to local.");
            SolarFluxAPI.SOLAR_PANELS.forEach(SolarInfo::resetConfigInstance);
        }
    }

    private void registerRender(Item item) {
        SolarFlux.LOG.info("Model definition for item " + item.getRegistryName());
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

