/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileUtil {
    public static void setOwner(World world, BlockPos pos, EntityLivingBase owner) {
        if (!(owner instanceof EntityPlayer)) {
            return;
        }
        TileUtil.setOwner(world, pos, (EntityPlayer)owner);
    }

    public static void setOwner(World world, BlockPos pos, EntityPlayer owner) {
        IGridNode node = TileUtil.getNode(world, pos);
        if (node == null) {
            return;
        }
        int playerID = AEApi.instance().registries().players().getID(owner);
        node.setPlayerID(playerID);
        node.updateState();
    }

    public static void destroy(World world, BlockPos pos) {
        IGridNode node = TileUtil.getNode(world, pos);
        if (node == null) {
            return;
        }
        node.destroy();
    }

    @Nullable
    public static IGridNode getNode(World world, BlockPos pos) {
        return TileUtil.getNode(world, pos, AEPartLocation.INTERNAL);
    }

    @Nullable
    public static IGridNode getNode(World world, BlockPos pos, AEPartLocation location) {
        IGridHost gridHost = TileUtil.getTile((IBlockAccess)world, pos, IGridHost.class);
        if (gridHost != null) {
            return gridHost.getGridNode(location);
        }
        return null;
    }

    @Nullable
    public static <T> T getTile(IBlockAccess world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    public static <T> void actOnTile(IBlockAccess world, BlockPos pos, Class<T> tileClass, ITileAction<T> tileAction) {
        T tile = TileUtil.getTile(world, pos, tileClass);
        if (tile != null) {
            tileAction.actOnTile(tile);
        }
    }

    @Nullable
    public static <T> T getCapability(World world, BlockPos pos, Capability<T> capability, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(capability, facing)) {
            return (T)tileEntity.getCapability(capability, facing);
        }
        return null;
    }

    public static interface ITileAction<T> {
        public void actOnTile(T var1);
    }
}

