/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.item.ItemTooltip;
import slimeknights.mantle.util.LocUtils;

public class ItemMetaDynamic
extends ItemTooltip {
    private static int MAX = 131071;
    protected boolean[] availabilityMask = new boolean[1];
    protected TIntObjectHashMap<String> names = new TIntObjectHashMap();

    public ItemMetaDynamic() {
        this.func_77627_a(true);
    }

    public ItemStack addMeta(int meta, String name) {
        if (meta > MAX) {
            throw new IllegalArgumentException(String.format("Metadata for %s too high, highest supported value is %d. Meta was %d", name, MAX, meta));
        }
        if (this.isValid(meta)) {
            throw new IllegalArgumentException(String.format("Metadata for %s is already taken. Meta %d is %s", name, meta, this.names.get(meta)));
        }
        while (meta >= this.availabilityMask.length) {
            this.availabilityMask = Arrays.copyOf(this.availabilityMask, this.availabilityMask.length * 2);
        }
        this.setValid(meta);
        this.names.put(meta, (Object)name);
        return new ItemStack((Item)this, 1, meta);
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (this.isValid(meta)) {
            return super.func_77667_c(stack) + "." + LocUtils.makeLocString((String)this.names.get(meta));
        }
        return super.func_77667_c(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i <= this.availabilityMask.length; ++i) {
                if (!this.isValid(i)) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public int func_77647_b(int damage) {
        int meta = super.func_77647_b(damage);
        return this.isValid(meta) ? meta : 0;
    }

    protected void setValid(int meta) {
        this.availabilityMask[meta] = true;
    }

    protected boolean isValid(int meta) {
        if (meta > MAX || meta >= this.availabilityMask.length) {
            return false;
        }
        return this.availabilityMask[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels() {
        this.registerItemModels(this);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerItemModels(final Item item) {
        String resourceId = Loader.instance().activeModContainer().getModId().toLowerCase();
        this.names.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

            public boolean execute(int meta, String name) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), name));
                return true;
            }
        });
    }
}

