/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser.expression;

import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionOrOr;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.expression.ParsedExpression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class ParsedExpressionOrOr
extends ParsedExpression {
    private final ParsedExpression left;
    private final ParsedExpression right;

    public ParsedExpressionOrOr(ZenPosition position, ParsedExpression left, ParsedExpression right) {
        super(position);
        this.left = left;
        this.right = right;
    }

    @Override
    public IPartialExpression compile(IEnvironmentMethod environment, ZenType predictedType) {
        ZenType type;
        Expression cLeft = this.left.compile(environment, predictedType).eval(environment);
        Expression cRight = this.right.compile(environment, predictedType).eval(environment);
        if (cRight.getType().canCastImplicit(cLeft.getType(), environment)) {
            type = cLeft.getType();
        } else if (cLeft.getType().canCastImplicit(cRight.getType(), environment)) {
            type = cRight.getType();
        } else {
            environment.error(this.getPosition(), "These types could not be unified: " + cLeft.getType() + " and " + cRight.getType());
            type = ZenType.ANY;
        }
        return new ExpressionOrOr(this.getPosition(), cLeft.cast(this.getPosition(), environment, type), cRight.cast(this.getPosition(), environment, type));
    }
}

