/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.skyblock.modifiers;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.skyblock.modifiers.AbstractModBreaker;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

@Mod.EventBusSubscriber
public class ModCobbleBreaker
extends AbstractModBreaker {
    public static final String IDENTIFIER = "cobble_breaker";

    public ModCobbleBreaker() {
        super(IDENTIFIER, 0x989898);
    }

    @Override
    protected boolean checkCondition(IBlockState state, World entityWorld, BlockPos pos) {
        return state.func_185904_a() == Material.field_151576_e && state.func_177230_c().getHarvestLevel(state) <= 0;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent breakEvent) {
        EntityPlayer player = breakEvent.getPlayer();
        if (player == null || breakEvent.getState().func_177230_c() != Blocks.field_150347_e) {
            return;
        }
        ItemStack itemStack = player.func_184614_ca();
        if (!TinkerUtil.hasModifier((NBTTagCompound)TagUtil.getTagSafe((ItemStack)itemStack), (String)IDENTIFIER)) {
            return;
        }
        if (!breakEvent.getWorld().field_72995_K && ModCobbleBreaker.isCobbleGen(breakEvent.getWorld(), breakEvent.getPos())) {
            breakEvent.setCanceled(true);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150347_e));
        }
    }

    private static boolean isCobbleGen(World world, BlockPos pos) {
        boolean hasWater = false;
        boolean hasLava = false;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            IBlockState adjacentState = world.func_180495_p(pos.func_177972_a(enumFacing));
            hasWater |= adjacentState.func_177230_c() == Blocks.field_150355_j;
            hasWater |= adjacentState.func_177230_c() == Blocks.field_150358_i;
            hasLava |= adjacentState.func_177230_c() == Blocks.field_150353_l;
            hasLava |= adjacentState.func_177230_c() == Blocks.field_150356_k;
        }
        return hasLava && hasWater;
    }
}

