/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.skyblock.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.skyblock.config.Config;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ItemRations
extends ItemFood
implements IRepairable {
    public static final String LOC_USES = "stat.spaghetti.uses.name";
    private static final int FOOD_AMOUNT = 2;
    private static final float SATURATION = 0.5f;

    public ItemRations() {
        super(2, 0.5f, false);
        this.func_77656_e(50);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (Config.INSTANCE.configFile.enableRations) {
            super.func_150895_a(tab, items);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (this.canEatRations(playerIn) || !this.hasDurability(heldItem)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private boolean canEatRations(EntityPlayer player) {
        return player.func_71024_bL().func_75116_a() >= 16;
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.hasDurability(stack)) {
            stack.func_77964_b(stack.func_77952_i() + 1);
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityLiving;
                entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
                worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                StatBase statBase = StatList.func_188057_b((Item)this);
                assert (statBase != null);
                entityplayer.func_71029_a(statBase);
            }
        }
        return stack;
    }

    private boolean hasDurability(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    public int func_77626_a(ItemStack stack) {
        return 10;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    @Nonnull
    public ItemStack repair(ItemStack repairable, NonNullList<ItemStack> repairItems) {
        if (repairable.func_77952_i() == 0) {
            return ItemStack.field_190927_a;
        }
        if (repairItems.stream().filter(stack -> !stack.func_190926_b()).anyMatch(this::isNoFood)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack2 = repairable.func_77946_l();
        boolean repaired = false;
        int index = 0;
        while (stack2.func_77952_i() > 0 && index < repairItems.size()) {
            ItemStack repairItem = (ItemStack)repairItems.get(index);
            if (!repairItem.func_190926_b() && repairItem.func_190916_E() > 0) {
                int change = ((ItemFood)repairItem.func_77973_b()).func_150905_g(repairItem) / 2;
                change = Math.max(1, change);
                stack2.func_77964_b(stack2.func_77952_i() - change);
                ToolHelper.healTool((ItemStack)stack2, (int)change, null);
                repairItem.func_190918_g(1);
                repaired = true;
                continue;
            }
            ++index;
        }
        if (!repaired) {
            return ItemStack.field_190927_a;
        }
        return stack2;
    }

    public int getUses(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(String.format("%s: %s", Util.translate((String)LOC_USES, (Object[])new Object[0]), CustomFontColor.formatPartialAmount((int)this.getUses(stack), (int)this.getMaxDamage(stack))));
        tooltip.add(Util.translate((String)"item.tinkerskyblock.rations.tooltip1", (Object[])new Object[0]));
        tooltip.add(Util.translate((String)"item.tinkerskyblock.rations.tooltip2", (Object[])new Object[0]));
        tooltip.add(Util.translate((String)"item.tinkerskyblock.rations.tooltip3", (Object[])new Object[0]));
        tooltip.add(Util.translate((String)"item.tinkerskyblock.rations.tooltip4", (Object[])new Object[0]));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    private boolean isNoFood(ItemStack itemStack) {
        return !(itemStack.func_77973_b() instanceof ItemFood) || itemStack.func_77973_b() == Items.field_151078_bh;
    }
}

