/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.skyblock.events;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.skyblock.TinkerSkyblock;
import slimeknights.skyblock.Tools;
import slimeknights.skyblock.config.Config;
import slimeknights.tconstruct.library.utils.TagUtil;

@Mod.EventBusSubscriber
public class PlayerDataEvents {
    public static final String TAG_HAS_PICK = "tinkerskyblock.pick";
    public static final String TAG_HAS_AXE = "tinkerskyblock.axe";
    public static final String TAG_HAS_SCYTHE = "tinkerskyblock.scythe";
    public static final String TAG_HAS_PAN = "tinkerskyblock.pan";
    public static final String TAG_HAS_RATIONS = "tinkerskyblock.rations";

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerDataEvents.giveItemsToPlayer(event.player, false);
    }

    public static void giveItemsToPlayer(EntityPlayer player, boolean ignoreTag) {
        if (Config.INSTANCE.configFile.enableBaneOfCobble) {
            PlayerDataEvents.getStackIfNeeded(player, TAG_HAS_PICK, Tools::buildCobblePick, ignoreTag);
        }
        if (Config.INSTANCE.configFile.enableBaneOfLogs) {
            PlayerDataEvents.getStackIfNeeded(player, TAG_HAS_AXE, Tools::buildTreeAxe, ignoreTag);
        }
        if (Config.INSTANCE.configFile.enableBaneOfLeaves) {
            PlayerDataEvents.getStackIfNeeded(player, TAG_HAS_SCYTHE, Tools::buildLeafScythe, ignoreTag);
        }
        if (Config.INSTANCE.configFile.enablePersonalSpaceEnforcer) {
            PlayerDataEvents.getStackIfNeeded(player, TAG_HAS_PAN, Tools::buildFryPan, ignoreTag);
        }
        if (Config.INSTANCE.configFile.enableRations) {
            PlayerDataEvents.getStackIfNeeded(player, TAG_HAS_RATIONS, () -> new ItemStack((Item)TinkerSkyblock.itemRations), ignoreTag);
        }
    }

    private static void getStackIfNeeded(EntityPlayer player, String tag, Supplier<ItemStack> getStack, boolean ignoreTag) {
        NBTTagCompound playerData = player.getEntityData();
        NBTTagCompound data = TagUtil.getTagSafe((NBTTagCompound)playerData, (String)"PlayerPersisted");
        if (!data.func_74767_n(tag) || ignoreTag) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)getStack.get());
            data.func_74757_a(tag, true);
            playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
        }
    }
}

