/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;
import org.cyclops.cyclopscore.helper.Helpers;

public class IngredientComponentStorageWrapperHandlerItemStackSlotless
implements IIngredientComponentStorageWrapperHandler<ItemStack, Integer, ISlotlessItemHandler> {
    private final IngredientComponent<ItemStack, Integer> ingredientComponent;

    public IngredientComponentStorageWrapperHandlerItemStackSlotless(IngredientComponent<ItemStack, Integer> ingredientComponent) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
    }

    @Override
    public IIngredientComponentStorage<ItemStack, Integer> wrapComponentStorage(ISlotlessItemHandler storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public ISlotlessItemHandler wrapStorage(IIngredientComponentStorage<ItemStack, Integer> componentStorage) {
        return new ItemStorageWrapper(this.getComponent(), componentStorage);
    }

    @Override
    @Nullable
    public ISlotlessItemHandler getStorage(ICapabilityProvider capabilityProvider, @Nullable EnumFacing facing) {
        return (ISlotlessItemHandler)capabilityProvider.getCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
    }

    @Override
    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    public static class ItemStorageWrapper
    implements ISlotlessItemHandler {
        private final IngredientComponent<ItemStack, Integer> ingredientComponent;
        private final IIngredientComponentStorage<ItemStack, Integer> storage;

        public ItemStorageWrapper(IngredientComponent<ItemStack, Integer> ingredientComponent, IIngredientComponentStorage<ItemStack, Integer> storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public Iterator<ItemStack> getItems() {
            return this.storage.iterator();
        }

        @Override
        public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
            return this.storage.iterator(stack, matchFlags);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
            return this.storage.insert(stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int amount, boolean simulate) {
            return this.storage.extract(amount, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
            return this.storage.extract(matchStack, matchFlags, simulate);
        }

        @Override
        public int getLimit() {
            return Helpers.castSafe((long)this.storage.getMaxQuantity());
        }
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<ItemStack, Integer> {
        private final IngredientComponent<ItemStack, Integer> ingredientComponent;
        private final ISlotlessItemHandler storage;

        public ComponentStorageWrapper(IngredientComponent<ItemStack, Integer> ingredientComponent, ISlotlessItemHandler storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<ItemStack, Integer> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this.storage.getItems();
        }

        @Override
        public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchFlags) {
            return this.storage.findItems(prototype, matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storage.getLimit();
        }

        @Override
        public ItemStack insert(@Nonnull ItemStack ingredient, boolean simulate) {
            return this.storage.insertItem(ingredient, simulate);
        }

        @Override
        public ItemStack extract(@Nonnull ItemStack prototype, Integer matchFlags, boolean simulate) {
            return this.storage.extractItem(prototype, matchFlags, simulate);
        }

        @Override
        public ItemStack extract(long maxQuantity, boolean simulate) {
            return this.storage.extractItem(Helpers.castSafe((long)maxQuantity), simulate);
        }
    }
}

