/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IMixedIngredients
extends Comparable<IMixedIngredients> {
    public Set<IngredientComponent<?, ?>> getComponents();

    public <T> List<T> getInstances(IngredientComponent<T, ?> var1);

    default public <T> T getFirstNonEmpty(IngredientComponent<T, ?> ingredientComponent) {
        IIngredientMatcher<T, ?> matcher = ingredientComponent.getMatcher();
        for (T instance : this.getInstances(ingredientComponent)) {
            if (matcher.isEmpty(instance)) continue;
            return instance;
        }
        return matcher.getEmptyInstance();
    }

    default public boolean containsAll(IMixedIngredients that) {
        if (!this.getComponents().containsAll(that.getComponents())) {
            return false;
        }
        for (IngredientComponent<?, ?> component : that.getComponents()) {
            ArrayList thisInstances = Lists.newArrayList(this.getInstances(component));
            List<?> thatInstances = that.getInstances(component);
            IIngredientMatcher<?, ?> matcher = component.getMatcher();
            for (Object thatInstance : thatInstances) {
                boolean found = false;
                Iterator it = thisInstances.iterator();
                while (it.hasNext() && !found) {
                    if (!matcher.matchesExactly(thatInstance, it.next())) continue;
                    found = true;
                    it.remove();
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean isEmpty() {
        for (IngredientComponent<?, ?> component : this.getComponents()) {
            IIngredientMatcher<?, ?> matcher = component.getMatcher();
            for (Object instance : this.getInstances(component)) {
                if (matcher.isEmpty(instance)) continue;
                return false;
            }
        }
        return true;
    }

    public static NBTTagCompound serialize(IMixedIngredients ingredients) {
        NBTTagCompound tag = new NBTTagCompound();
        for (IngredientComponent<?, ?> component : ingredients.getComponents()) {
            NBTTagList instances = new NBTTagList();
            IIngredientSerializer<?, ?> serializer = component.getSerializer();
            for (Object instance : ingredients.getInstances(component)) {
                instances.func_74742_a(serializer.serializeInstance(instance));
            }
            tag.func_74782_a(component.getRegistryName().toString(), (NBTBase)instances);
        }
        return tag;
    }

    public static MixedIngredients deserialize(NBTTagCompound tag) throws IllegalArgumentException {
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        for (String componentName : tag.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            NBTBase subTag = tag.func_74781_a(componentName);
            if (!(subTag instanceof NBTTagList)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            NBTTagList instancesTag = (NBTTagList)subTag;
            IIngredientSerializer serializer = component.getSerializer();
            ArrayList instances = Lists.newArrayList();
            for (NBTBase instanceTag : instancesTag) {
                instances.add(serializer.deserializeInstance(instanceTag));
            }
            ingredients.put(component, instances);
        }
        return new MixedIngredients(ingredients);
    }
}

