/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public class FilteredItemHandlerItemStackIterator
implements Iterator<ItemStack> {
    private final IItemHandler itemHandler;
    private final ItemStack prototype;
    private final int matchFlags;
    private int slot = 0;
    private ItemStack next;

    public FilteredItemHandlerItemStackIterator(IItemHandler itemHandler, ItemStack prototype, int matchFlags) {
        this.itemHandler = itemHandler;
        this.prototype = prototype;
        this.matchFlags = matchFlags;
        this.next = this.findNext();
    }

    protected ItemStack findNext() {
        while (this.slot < this.itemHandler.getSlots()) {
            ItemStack itemStack;
            if (!ItemMatch.areItemStacksEqual(itemStack = this.itemHandler.getStackInSlot(this.slot++), this.prototype, this.matchFlags)) continue;
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ItemStack next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Slot out of bounds");
        }
        ItemStack next = this.next;
        this.next = this.findNext();
        return next;
    }
}

